/// <reference path="./internal_*.d.ts" />
declare namespace Internal {
    interface SpriteContentsExtended {
        abstract sodium$setActive(arg0: boolean): void;
        abstract sodium$isActive(): boolean;
        abstract sodium$hasAnimation(): boolean;
    }
    type SpriteContentsExtended_ = SpriteContentsExtended;
    class DragonType {
        constructor(name: string, entityType: Internal.Supplier_<Internal.EntityType<Internal.EntityDragonBase>>, skullItem: Internal.Supplier_<Internal.Item>, crystalItem: Internal.Supplier_<Internal.Item>)
        getSkullItem(): Internal.Item;
        static getNameFromInt(type: number): string;
        static getTypeByEntityType(type: Internal.EntityType_<any>): Internal.DragonType;
        getName(): string;
        getEntity(): Internal.EntityType<Internal.EntityDragonBase>;
        static getTypeById(id: string): Internal.DragonType;
        getIntFromType(): number;
        getSkeletonTexture(stage: number): ResourceLocation;
        isPiscivore(): boolean;
        setPiscivore(): this;
        getCrystalItem(): Internal.Item;
        get skullItem(): Internal.Item
        get name(): string
        get entity(): Internal.EntityType<Internal.EntityDragonBase>
        get intFromType(): number
        get piscivore(): boolean
        get crystalItem(): Internal.Item
        static readonly ICE: Internal.DragonType;
        static readonly FIRE: Internal.DragonType;
        static readonly LIGHTNING: Internal.DragonType;
    }
    type DragonType_ = DragonType;
    abstract class ValueListDisplaySource extends Internal.DisplaySource {
        constructor()
    }
    type ValueListDisplaySource_ = ValueListDisplaySource;
    class AppendStatic implements Internal.RuleBlockEntityModifier {
        constructor($$0: Internal.CompoundTag_)
        getType(): Internal.RuleBlockEntityModifierType<any>;
        apply($$0: Internal.RandomSource_, $$1: Internal.CompoundTag_): Internal.CompoundTag;
        get type(): Internal.RuleBlockEntityModifierType<any>
        static readonly CODEC: Internal.Codec<Internal.AppendStatic>;
    }
    type AppendStatic_ = AppendStatic;
    interface SpruceWidget extends Internal.SpruceElement, Internal.SprucePositioned, Internal.NarratableEntry, Internal.Renderable {
        charTyped($$0: string, $$1: number): boolean;
        abstract isFocused(): boolean;
        isFocusedOrHovered(): boolean;
        getX(): number;
        getY(): number;
        abstract setFocused(arg0: boolean): void;
        abstract isActive(): boolean;
        getTabOrderGroup(): number;
        mouseScrolled($$0: number, $$1: number, $$2: number): boolean;
        keyReleased($$0: number, $$1: number, $$2: number): boolean;
        mouseClicked($$0: number, $$1: number, $$2: number): boolean;
        getEndY(): number;
        mouseDragged($$0: number, $$1: number, $$2: number, $$3: number, $$4: number): boolean;
        abstract getHeight(): number;
        mouseMoved($$0: number, $$1: number): void;
        abstract setActive(arg0: boolean): void;
        abstract isVisible(): boolean;
        getRectangle(): Internal.ScreenRectangle;
        nextFocusPath($$0: Internal.FocusNavigationEvent_): Internal.ComponentPath;
        abstract getWidth(): number;
        abstract narrationPriority(): Internal.NarratableEntry$NarrationPriority;
        requiresCursor(): boolean;
        mouseReleased($$0: number, $$1: number, $$2: number): boolean;
        abstract getPosition(): dev.lambdaurora.spruceui.Position;
        keyPressed($$0: number, $$1: number, $$2: number): boolean;
        getEndX(): number;
        abstract setDragging(arg0: boolean): void;
        getCurrentFocusPath(): Internal.ComponentPath;
        abstract updateNarration(arg0: Internal.NarrationElementOutput_): void;
        isMouseHovered(): boolean;
        abstract render(arg0: Internal.GuiGraphics_, arg1: number, arg2: number, arg3: number): void;
        abstract isDragging(): boolean;
        onNavigation(direction: Internal.NavigationDirection_, tab: boolean): boolean;
        isMouseOver(mouseX: number, mouseY: number): boolean;
        abstract setVisible(arg0: boolean): void;
        get focused(): boolean
        get focusedOrHovered(): boolean
        get x(): number
        get y(): number
        set focused(arg0: boolean)
        get active(): boolean
        get tabOrderGroup(): number
        get endY(): number
        get height(): number
        set active(arg0: boolean)
        get visible(): boolean
        get rectangle(): Internal.ScreenRectangle
        get width(): number
        get position(): dev.lambdaurora.spruceui.Position
        get endX(): number
        set dragging(arg0: boolean)
        get currentFocusPath(): Internal.ComponentPath
        get mouseHovered(): boolean
        get dragging(): boolean
        set visible(arg0: boolean)
    }
    type SpruceWidget_ = SpruceWidget;
    interface ITickManager extends Internal.IGridService {
        abstract sleepDevice(arg0: Internal.IGridNode_): boolean;
        abstract alertDevice(arg0: Internal.IGridNode_): boolean;
        abstract wakeDevice(arg0: Internal.IGridNode_): boolean;
    }
    type ITickManager_ = ITickManager;
    class BedBlock extends Internal.HorizontalDirectionalBlock implements Internal.EntityBlock {
        constructor($$0: Internal.DyeColor_, $$1: Internal.BlockBehaviour$Properties_)
        newBlockEntity($$0: BlockPos_, $$1: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        static getBedOrientation($$0: Internal.BlockGetter_, $$1: BlockPos_): Internal.Direction;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        static getBlockType($$0: Internal.BlockState_): Internal.DoubleBlockCombiner$BlockType;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        static canSetSpawn($$0: Internal.Level_): boolean;
        getColor(): Internal.DyeColor;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        static getConnectedDirection($$0: Internal.BlockState_): Internal.Direction;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static findStandUpPosition($$0: Internal.EntityType_<any>, $$1: Internal.CollisionGetter_, $$2: BlockPos_, $$3: Internal.Direction_, $$4: number): Internal.Optional<Vec3d>;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get color(): Internal.DyeColor
        set destroySpeed(v: number)
        static readonly PART: Internal.EnumProperty<Internal.BedPart>;
        static readonly OCCUPIED: Internal.BooleanProperty;
    }
    type BedBlock_ = BedBlock;
    interface ModuleReader extends Internal.Closeable {
        abstract find(arg0: string): Internal.Optional<Internal.URI>;
        abstract close(): void;
        abstract list(): Internal.Stream<string>;
        open(arg0: string): Internal.Optional<Internal.InputStream>;
        release(arg0: Internal.ByteBuffer_): void;
        read(arg0: string): Internal.Optional<Internal.ByteBuffer>;
    }
    type ModuleReader_ = ModuleReader;
    class TrainStatus$StatusMessage extends Internal.Record {
        constructor(...messages: net.minecraft.network.chat.Component_[])
        displayToPlayer(player: Internal.Player_): void;
        messages(): net.minecraft.network.chat.Component[];
    }
    type TrainStatus$StatusMessage_ = TrainStatus$StatusMessage;
    class GlowInkSacItem extends Internal.Item implements Internal.SignApplicator {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        tryApplyToSign($$0: Internal.Level_, $$1: Internal.SignBlockEntity_, $$2: boolean, $$3: Internal.Player_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        canApplyToSign($$0: Internal.SignText_, $$1: Internal.Player_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type GlowInkSacItem_ = GlowInkSacItem;
    class BlockStateProvider$ConfiguredModelList {
        constructor(...models: Internal.ConfiguredModel_[])
        constructor(model: Internal.ConfiguredModel_)
        append(...models: Internal.ConfiguredModel_[]): this;
        toJSON(): Internal.JsonElement;
    }
    type BlockStateProvider$ConfiguredModelList_ = BlockStateProvider$ConfiguredModelList;
    class DragonArmorMaterial {
        constructor(name: string, protection: number)
        static getArmorTexture(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): ResourceLocation;
        getId(): string;
        getTexture(slot: Internal.EquipmentSlot_): ResourceLocation;
        static values(): Internal.List<Internal.DragonArmorMaterial>;
        getProtection(): number;
        get id(): string
        get protection(): number
        static readonly DRAGON_STEEL_LIGHTNING: Internal.DragonArmorMaterial;
        static readonly NETHERITE: Internal.DragonArmorMaterial;
        static readonly SILVER: Internal.DragonArmorMaterial;
        static readonly DIAMOND: Internal.DragonArmorMaterial;
        static readonly GOLD: Internal.DragonArmorMaterial;
        static readonly COPPER: Internal.DragonArmorMaterial;
        static readonly IRON: Internal.DragonArmorMaterial;
        static readonly DRAGON_STEEL_ICE: Internal.DragonArmorMaterial;
        static readonly DRAGON_STEEL_FIRE: Internal.DragonArmorMaterial;
    }
    type DragonArmorMaterial_ = DragonArmorMaterial;
    class TimerQueue <T> {
        constructor($$0: any_<T>, $$1: Internal.Stream_<Internal.Dynamic<any>>)
        constructor($$0: any_<T>)
        getEventsIds(): Internal.Set<string>;
        schedule($$0: string, $$1: number, $$2: Internal.TimerCallback_<T>): void;
        remove($$0: string): number;
        store(): Internal.ListTag;
        tick($$0: T, $$1: number): void;
        get eventsIds(): Internal.Set<string>
    }
    type TimerQueue_<T> = TimerQueue<T>;
    interface WidgetLayout {
        getLayoutPadding(): Internal.WidgetLayout$Padding;
        abstract align(arg0: Internal.Panel_): number;
        get layoutPadding(): Internal.WidgetLayout$Padding
        (arg0: Internal.Panel): number;
        readonly NO_PADDING: Internal.WidgetLayout$Padding;
        readonly NONE: Internal.WidgetLayout;
        readonly HORIZONTAL: Internal.WidgetLayout$Horizontal;
        readonly VERTICAL: Internal.WidgetLayout$Vertical;
    }
    type WidgetLayout_ = WidgetLayout;
    interface EntityDataSerializer <T> {
        simple<T>($$0: Internal.FriendlyByteBuf$Writer_<T>, $$1: Internal.FriendlyByteBuf$Reader_<T>): this;
        simpleId<T>($$0: Internal.IdMap_<T>): this;
        createAccessor($$0: number): Internal.EntityDataAccessor<T>;
        simpleEnum<T extends Internal.Enum<T>>($$0: T): this;
        optional<T>($$0: Internal.FriendlyByteBuf$Writer_<T>, $$1: Internal.FriendlyByteBuf$Reader_<T>): Internal.EntityDataSerializer<Internal.Optional<T>>;
        abstract copy(arg0: T): T;
        abstract write(arg0: Internal.FriendlyByteBuf_, arg1: T): void;
        abstract read(arg0: Internal.FriendlyByteBuf_): T;
    }
    type EntityDataSerializer_<T> = EntityDataSerializer<T>;
    interface SurfaceRules$SurfaceRule {
        abstract tryApply(arg0: number, arg1: number, arg2: number): Internal.BlockState;
        (arg0: number, arg1: number, arg2: number): Internal.BlockState_;
    }
    type SurfaceRules$SurfaceRule_ = SurfaceRules$SurfaceRule;
    class SignDisplayTarget extends Internal.DisplayTarget {
        constructor()
    }
    type SignDisplayTarget_ = SignDisplayTarget;
    class PumpkinBlock extends Internal.StemGrownBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type PumpkinBlock_ = PumpkinBlock;
    class TelemetryPropertyMap$Builder {
        putAll($$0: Internal.TelemetryPropertyMap_): this;
        putIfNotNull<T>($$0: Internal.TelemetryProperty_<T>, $$1: T): this;
        put<T>($$0: Internal.TelemetryProperty_<T>, $$1: T): this;
        build(): Internal.TelemetryPropertyMap;
    }
    type TelemetryPropertyMap$Builder_ = TelemetryPropertyMap$Builder;
    class PotatoProjectileEntity extends Internal.AbstractHurtingProjectile implements Internal.IEntityAdditionalSpawnData {
        constructor(type: Internal.EntityType_<Internal.AbstractHurtingProjectile>, level: Internal.Level_)
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        getDistance(pos: BlockPos_): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        getStuckEntity(): Internal.Entity;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setRotation(yaw: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        isOnScoreboardTeam(teamId: string): boolean;
        setItem(stack: Internal.ItemStack_): void;
        getType(): string;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        self(): Internal.Entity;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getBlock(): Internal.BlockContainerJS;
        static playHitSound(world: Internal.Level_, location: Vec3d_): void;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        setPosition(x: number, y: number, z: number): void;
        getPassengers(): Internal.EntityArrayList;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        sophisticatedInvalidateCaps(): void;
        static build(builder: Internal.FabricEntityTypeBuilder_<any>): Internal.FabricEntityTypeBuilder<any>;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isLiving(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        alwaysAccepts(): boolean;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        setStuckEntity(stuckEntity: Internal.Entity_): void;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        getDisplayName(): net.minecraft.network.chat.Component;
        setMotionX(x: number): void;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        attack(hp: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        readSpawnData(additionalData: Internal.FriendlyByteBuf_): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTeamId(): string;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        serializeNBT(): Internal.Tag;
        setDynamicLightEnabled(enabled: boolean): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        writeSpawnData(buffer: Internal.FriendlyByteBuf_): void;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        getProjectileType(): Internal.PotatoCannonProjectileType;
        static playLaunchSound(world: Internal.Level_, location: Vec3d_, pitch: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        isFrame(): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getProfile(): Internal.GameProfile;
        playSound(id: Internal.SoundEvent_): void;
        lithiumOnBlockCacheDeleted(): void;
        getRenderMode(): Internal.PotatoProjectileRenderMode;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        runCommand(command: string): number;
        setEnchantmentEffectsFromCannon(cannon: Internal.ItemStack_): void;
        getDistance(x: number, y: number, z: number): number;
        set motionY(y: number)
        get peacefulCreature(): boolean
        get stuckEntity(): Internal.Entity
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        set item(stack: Internal.ItemStack_)
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        set stuckEntity(stuckEntity: Internal.Entity_)
        get server(): Internal.MinecraftServer
        get displayName(): net.minecraft.network.chat.Component
        set motionX(x: number)
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get facing(): Internal.Direction
        set dynamicLightEnabled(enabled: boolean)
        get motionX(): number
        get waterCreature(): boolean
        get motionZ(): number
        get item(): Internal.ItemStack
        set x(x: number)
        get projectileType(): Internal.PotatoCannonProjectileType
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get frame(): boolean
        get profile(): Internal.GameProfile
        get renderMode(): Internal.PotatoProjectileRenderMode
        set enchantmentEffectsFromCannon(cannon: Internal.ItemStack_)
    }
    type PotatoProjectileEntity_ = PotatoProjectileEntity;
    class WeaponRackItem extends Internal.Item {
        constructor(settings: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type WeaponRackItem_ = WeaponRackItem;
    interface VertexFormatExtensions {
        getOffset(index: number): number;
    }
    type VertexFormatExtensions_ = VertexFormatExtensions;
    class DensityFunctions$YClampedGradient extends Internal.Record implements Internal.DensityFunction$SimpleFunction {
        halfNegative(): Internal.DensityFunction;
        abs(): Internal.DensityFunction;
        maxValue(): number;
        toValue(): number;
        codec(): Internal.KeyDispatchDataCodec<Internal.DensityFunction>;
        compute($$0: Internal.DensityFunction$FunctionContext_): number;
        squeeze(): Internal.DensityFunction;
        fromValue(): number;
        square(): Internal.DensityFunction;
        fromY(): number;
        mapAll($$0: Internal.DensityFunction$Visitor_): Internal.DensityFunction;
        clamp($$0: number, $$1: number): Internal.DensityFunction;
        toY(): number;
        quarterNegative(): Internal.DensityFunction;
        cube(): Internal.DensityFunction;
        fillArray($$0: number[], $$1: Internal.DensityFunction$ContextProvider_): void;
        minValue(): number;
        static readonly CODEC: Internal.KeyDispatchDataCodec<Internal.DensityFunctions$YClampedGradient>;
    }
    type DensityFunctions$YClampedGradient_ = DensityFunctions$YClampedGradient;
    interface Double2IntFunction extends it.unimi.dsi.fastutil.Function<number, number>, Internal.DoubleToIntFunction {
        abstract get(arg0: number): number;
        put(arg0: number, arg1: number): number;
        composeByte(arg0: Internal.Byte2DoubleFunction_): Internal.Byte2IntFunction;
        andThenDouble(arg0: Internal.Int2DoubleFunction_): Internal.Double2DoubleFunction;
        andThenFloat(arg0: Internal.Int2FloatFunction_): Internal.Double2FloatFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        defaultReturnValue(): number;
        composeReference<T>(arg0: Internal.Reference2DoubleFunction_<T>): Internal.Reference2IntFunction<T>;
        composeObject<T>(arg0: Internal.Object2DoubleFunction_<T>): Internal.Object2IntFunction<T>;
        composeDouble(arg0: Internal.Double2DoubleFunction_): this;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        composeShort(arg0: Internal.Short2DoubleFunction_): Internal.Short2IntFunction;
        composeInt(arg0: Internal.Int2DoubleFunction_): Internal.Int2IntFunction;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        apply(arg0: number): number;
        andThenReference<T>(arg0: Internal.Int2ReferenceFunction_<T>): Internal.Double2ReferenceFunction<T>;
        andThenLong(arg0: Internal.Int2LongFunction_): Internal.Double2LongFunction;
        composeFloat(arg0: Internal.Float2DoubleFunction_): Internal.Float2IntFunction;
        andThenByte(arg0: Internal.Int2ByteFunction_): Internal.Double2ByteFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        remove(arg0: number): number;
        getOrDefault(arg0: number, arg1: number): number;
        composeChar(arg0: Internal.Char2DoubleFunction_): Internal.Char2IntFunction;
        containsKey(arg0: number): boolean;
        andThenShort(arg0: Internal.Int2ShortFunction_): Internal.Double2ShortFunction;
        size(): number;
        andThenChar(arg0: Internal.Int2CharFunction_): Internal.Double2CharFunction;
        defaultReturnValue(arg0: number): void;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: number): number;
        clear(): void;
        andThenObject<T>(arg0: Internal.Int2ObjectFunction_<T>): Internal.Double2ObjectFunction<T>;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        andThenInt(arg0: Internal.Int2IntFunction_): this;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        composeLong(arg0: Internal.Long2DoubleFunction_): Internal.Long2IntFunction;
        identity<T>(): Internal.Function<T, T>;
        applyAsInt(arg0: number): number;
        (arg0: number): number;
    }
    type Double2IntFunction_ = Double2IntFunction;
    class ContraptionControlsBlock extends Internal.ControlsBlock implements Internal.IBE<Internal.ContraptionControlsBlockEntity> {
        constructor(pProperties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.ContraptionControlsBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.ContraptionControlsBlockEntity>): void;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getBlockEntityClass(): typeof Internal.ContraptionControlsBlockEntity;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.ContraptionControlsBlockEntity>;
        setDestroySpeed(v: number): void;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.ContraptionControlsBlockEntity;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockEntityType(): Internal.BlockEntityType<Internal.ContraptionControlsBlockEntity>;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockEntityClass(): typeof Internal.ContraptionControlsBlockEntity
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityType(): Internal.BlockEntityType<Internal.ContraptionControlsBlockEntity>
    }
    type ContraptionControlsBlock_ = ContraptionControlsBlock;
    class MinecartChest extends Internal.AbstractMinecartContainer {
        constructor($$0: Internal.EntityType_<Internal.MinecartChest>, $$1: Internal.Level_)
        constructor($$0: Internal.Level_, $$1: number, $$2: number, $$3: number)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        addChestVehicleSaveData($$0: Internal.CompoundTag_): void;
        isChestVehicleEmpty(): boolean;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        clear(ingredient: Internal.Ingredient_): void;
        find(): number;
        hasAnyOf($$0: Internal.Set_<Internal.Item>): boolean;
        setChanged(): void;
        isOnScoreboardTeam(teamId: string): boolean;
        isChestVehicleStillValid($$0: Internal.Player_): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        getWidth(): number;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        isLiving(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        alwaysAccepts(): boolean;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        chestVehicleDestroyed($$0: DamageSource_, $$1: Internal.Level_, $$2: Internal.Entity_): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        getMaxSpeedOnRail(): number;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        countItem($$0: Internal.Item_): number;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        startOpen($$0: Internal.Player_): void;
        canPlaceItem($$0: number, $$1: Internal.ItemStack_): boolean;
        getTeamId(): string;
        removeChestVehicleItem($$0: number, $$1: number): Internal.ItemStack;
        getFacing(): Internal.Direction;
        getChestVehicleItem($$0: number): Internal.ItemStack;
        canRiderInteract(): boolean;
        shouldCloseCurrentScreen(): boolean;
        getHeight(): number;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        removeChestVehicleItemNoUpdate($$0: number): Internal.ItemStack;
        countNonEmpty(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        generateLootLithium(): void;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        playSound(id: Internal.SoundEvent_): void;
        clear(): void;
        method_17357($$0: number, $$1: Internal.Inventory_): Internal.AbstractContainerMenu;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        self(): net.minecraft.world.Container;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static tryClear($$0: any): void;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getSlots(): number;
        getType(): string;
        interactWithContainerVehicle($$0: Internal.Player_): Internal.InteractionResult;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        sophisticatedInvalidateCaps(): void;
        clearChestVehicleContent(): void;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        unpackChestVehicleLootTable($$0: Internal.Player_): void;
        getChestVehicleSlot($$0: number): Internal.SlotAccess;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        count(ingredient: Internal.Ingredient_): number;
        setMotionX(x: number): void;
        count(): number;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        setTransferCooldown(currentTime: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        isEmpty(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        serializeNBT(): Internal.Tag;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        canReceiveTransferCooldown(): boolean;
        setDynamicLightEnabled(enabled: boolean): void;
        readChestVehicleSaveData($$0: Internal.CompoundTag_): void;
        getStackInSlot(slot: number): Internal.ItemStack;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        asContainer(): net.minecraft.world.Container;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        getAllItems(): Internal.List<Internal.ItemStack>;
        tell(message: net.minecraft.network.chat.Component_): void;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        setZ(z: number): void;
        setChestVehicleItem($$0: number, $$1: Internal.ItemStack_): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        isMutable(): boolean;
        lithiumOnBlockCacheDeleted(): void;
        find(ingredient: Internal.Ingredient_): number;
        runCommand(command: string): number;
        get chestVehicleEmpty(): boolean
        get width(): number
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get displayName(): net.minecraft.network.chat.Component
        get maxSpeedOnRail(): number
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        get facing(): Internal.Direction
        get height(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get frame(): boolean
        set motionY(y: number)
        get peacefulCreature(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get slots(): number
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get maxStackSize(): number
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set transferCooldown(currentTime: number)
        get empty(): boolean
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set dynamicLightEnabled(enabled: boolean)
        get motionZ(): number
        get allItems(): Internal.List<Internal.ItemStack>
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        get mutable(): boolean
    }
    type MinecartChest_ = MinecartChest;
    interface FormattedText$StyledContentConsumer <T> {
        abstract accept(arg0: Internal.Style_, arg1: string): Internal.Optional<T>;
        (arg0: Internal.Style, arg1: string): Internal.Optional_<T>;
    }
    type FormattedText$StyledContentConsumer_<T> = FormattedText$StyledContentConsumer<T>;
    interface BundleItemAccessor {
        port_lib$getWeight(stack: Internal.ItemStack_): number;
    }
    type BundleItemAccessor_ = BundleItemAccessor;
    interface AutoCloseable {
        abstract close(): void;
        (): void;
    }
    type AutoCloseable_ = AutoCloseable;
    class PressingBehaviour$Mode extends Internal.Enum<Internal.PressingBehaviour$Mode> {
        static valueOf(name: string): Internal.PressingBehaviour$Mode;
        static values(): Internal.PressingBehaviour$Mode[];
        static readonly BELT: Internal.PressingBehaviour$Mode;
        headOffset: number;
        static readonly BASIN: Internal.PressingBehaviour$Mode;
        static readonly WORLD: Internal.PressingBehaviour$Mode;
    }
    type PressingBehaviour$Mode_ = "basin" | "world" | "belt" | PressingBehaviour$Mode;
    interface Registry <T> extends Internal.IdMap<T>, Internal.Keyable {
        asHolderIdMap(): Internal.IdMap<Internal.Holder<T>>;
        abstract getResourceKey(arg0: T): Internal.Optional<Internal.ResourceKey<T>>;
        abstract get(arg0: Internal.ResourceKey_<T>): T;
        abstract registryKeySet(): Internal.Set<Internal.ResourceKey<T>>;
        abstract keySet(): Internal.Set<ResourceLocation>;
        abstract getTagNames(): Internal.Stream<Internal.TagKey<T>>;
        keys<U>($$0: Internal.DynamicOps_<U>): Internal.Stream<U>;
        abstract key(): Internal.ResourceKey<Internal.Registry<T>>;
        abstract get(arg0: ResourceLocation_): T;
        abstract getTags(): Internal.Stream<com.mojang.datafixers.util.Pair<Internal.TagKey<T>, Internal.HolderSet$Named<T>>>;
        getTagOrEmpty($$0: Internal.TagKey_<T>): Internal.Iterable<Internal.Holder<T>>;
        abstract freeze(): this;
        abstract getRandom(arg0: Internal.RandomSource_): Internal.Optional<Internal.Holder$Reference<T>>;
        abstract holderOwner(): Internal.HolderOwner<T>;
        register<V, T extends V>($$0: Internal.Registry_<V>, $$1: Internal.ResourceKey_<V>, $$2: T): T;
        abstract lifecycle(arg0: T): Internal.Lifecycle;
        registerForHolder<T>($$0: Internal.Registry_<T>, $$1: ResourceLocation_, $$2: T): Internal.Holder$Reference<T>;
        asTagAddingLookup(): Internal.HolderLookup$RegistryLookup<T>;
        abstract getOrCreateTag(arg0: Internal.TagKey_<T>): Internal.HolderSet$Named<T>;
        abstract getId(arg0: T): number;
        register<V, T extends V>($$0: Internal.Registry_<V>, $$1: ResourceLocation_, $$2: T): T;
        getOrThrow($$0: Internal.ResourceKey_<T>): T;
        byNameCodec(): Internal.Codec<T>;
        registerMapping<V, T extends V>($$0: Internal.Registry_<V>, $$1: number, $$2: string, $$3: T): T;
        getHolderOrThrow($$0: Internal.ResourceKey_<T>): Internal.Holder$Reference<T>;
        spliterator(): Internal.Spliterator<T>;
        abstract containsKey(arg0: Internal.ResourceKey_<T>): boolean;
        byIdOrThrow($$0: number): T;
        abstract containsKey(arg0: ResourceLocation_): boolean;
        abstract bindTags(arg0: Internal.Map_<Internal.TagKey<T>, Internal.List<Internal.Holder<T>>>): void;
        abstract iterator(): Internal.Iterator<T>;
        registerForHolder<T>($$0: Internal.Registry_<T>, $$1: Internal.ResourceKey_<T>, $$2: T): Internal.Holder$Reference<T>;
        forEach(arg0: Internal.Consumer_<T>): void;
        holderByNameCodec(): Internal.Codec<Internal.Holder<T>>;
        abstract getHolder(arg0: Internal.ResourceKey_<T>): Internal.Optional<Internal.Holder$Reference<T>>;
        abstract registryLifecycle(): Internal.Lifecycle;
        abstract byId(arg0: number): T;
        abstract createIntrusiveHolder(arg0: T): Internal.Holder$Reference<T>;
        register<T>($$0: Internal.Registry_<T>, $$1: string, $$2: T): T;
        stream(): Internal.Stream<T>;
        getOptional($$0: Internal.ResourceKey_<T>): Internal.Optional<T>;
        getOptional($$0: ResourceLocation_): Internal.Optional<T>;
        abstract getTag(arg0: Internal.TagKey_<T>): Internal.Optional<Internal.HolderSet$Named<T>>;
        forStrings(arg0: Internal.Supplier_<Internal.Stream<string>>): Internal.Keyable;
        abstract size(): number;
        abstract entrySet(): Internal.Set<Internal.Map$Entry<Internal.ResourceKey<T>, T>>;
        abstract resetTags(): void;
        abstract getHolder(arg0: number): Internal.Optional<Internal.Holder$Reference<T>>;
        abstract getKey(arg0: T): ResourceLocation;
        abstract holders(): Internal.Stream<Internal.Holder$Reference<T>>;
        abstract asLookup(): Internal.HolderLookup$RegistryLookup<T>;
        abstract wrapAsHolder(arg0: T): Internal.Holder<T>;
        get tagNames(): Internal.Stream<Internal.TagKey<T>>
        get tags(): Internal.Stream<com.mojang.datafixers.util.Pair<Internal.TagKey<T>, Internal.HolderSet$Named<T>>>
    }
    type Registry_<T> = Registry<T>;
    class ShulkerBoxBlockEntity extends Internal.RandomizableContainerBlockEntity implements Internal.InventoryChangeTracker, Internal.SleepingBlockEntity, Internal.WorldlyContainer, Internal.LithiumInventory {
        constructor($$0: BlockPos_, $$1: Internal.BlockState_)
        constructor($$0: Internal.DyeColor_, $$1: BlockPos_, $$2: Internal.BlockState_)
        stopListenForMajorInventoryChanges(inventoryChangeListener: Internal.InventoryChangeListener_): void;
        static tryClear($$0: any): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        clear(ingredient: Internal.Ingredient_): void;
        find(): number;
        hasAnyOf($$0: Internal.Set_<Internal.Item>): boolean;
        getSlots(): number;
        isSleeping(): boolean;
        setChanged(): void;
        onLoad(): void;
        sleepOnlyCurrentTick(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getSlotsForFace($$0: Internal.Direction_): number[];
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        handler$elk004$lithium$setInventoryStackListReplacement(list: Internal.NonNullList_<any>, ci: Internal.CallbackInfo_): void;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setInventoryLithium(arg0: Internal.NonNullList_<any>): void;
        getSleepingTicker(): Internal.TickingBlockEntity;
        getColor(): Internal.DyeColor;
        invalidateCaps(): void;
        kjs$self(): net.minecraft.world.Container;
        getInventoryLithium(): Internal.NonNullList<any>;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        asComponentProvider(): Internal.ComponentProvider;
        setTickWrapper(tickWrapper: Internal.WrappedBlockEntityTickInvokerAccessor_): void;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        hasCustomName(): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getAnimationStatus(): Internal.ShulkerBoxBlockEntity$AnimationStatus;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        wakeUpNow(): void;
        fabric_onTransfer(slot: number, transaction: Internal.TransactionContext_): void;
        loadFromTag($$0: Internal.CompoundTag_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        setTicker(delegate: Internal.TickingBlockEntity_): void;
        getTickWrapper(): Internal.WrappedBlockEntityTickInvokerAccessor;
        canTakeItemThroughFace($$0: number, $$1: Internal.ItemStack_, $$2: Internal.Direction_): boolean;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        count(ingredient: Internal.Ingredient_): number;
        count(): number;
        emitCallbackReplaced(): void;
        setTransferCooldown(currentTime: number): void;
        countItem($$0: Internal.Item_): number;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        isEmpty(): boolean;
        isClosed(): boolean;
        canPlaceItem($$0: number, $$1: Internal.ItemStack_): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        static tick($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.ShulkerBoxBlockEntity_): void;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        canPlaceItemThroughFace($$0: number, $$1: Internal.ItemStack_, $$2: Internal.Direction_): boolean;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        getProgress($$0: number): number;
        shouldCloseCurrentScreen(): boolean;
        getBoundingBox($$0: Internal.BlockState_): Internal.AABB;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        canReceiveTransferCooldown(): boolean;
        getStackInSlot(slot: number): Internal.ItemStack;
        listenForContentChangesOnce(stackList: Internal.LithiumStackList_, inventoryChangeListener: Internal.InventoryChangeListener_): void;
        getHeight(): number;
        countNonEmpty(): number;
        listenForMajorInventoryChanges(inventoryChangeListener: Internal.InventoryChangeListener_): void;
        asContainer(): net.minecraft.world.Container;
        getAllItems(): Internal.List<Internal.ItemStack>;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        generateLootLithium(): void;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        startSleeping(): boolean;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        isMutable(): boolean;
        clear(): void;
        find(ingredient: Internal.Ingredient_): number;
        setSleepingTicker(sleepingTicker: Internal.TickingBlockEntity_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        get slots(): number
        get sleeping(): boolean
        set inventoryLithium(arg0: Internal.NonNullList_<any>)
        get sleepingTicker(): Internal.TickingBlockEntity
        get color(): Internal.DyeColor
        get inventoryLithium(): Internal.NonNullList<any>
        get width(): number
        get maxStackSize(): number
        set tickWrapper(tickWrapper: Internal.WrappedBlockEntityTickInvokerAccessor_)
        get animationStatus(): Internal.ShulkerBoxBlockEntity$AnimationStatus
        set ticker(delegate: Internal.TickingBlockEntity_)
        get tickWrapper(): Internal.WrappedBlockEntityTickInvokerAccessor
        set transferCooldown(currentTime: number)
        get empty(): boolean
        get closed(): boolean
        get height(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get mutable(): boolean
        set sleepingTicker(sleepingTicker: Internal.TickingBlockEntity_)
        static readonly MAX_LID_ROTATION: 270.0;
        static readonly CONTAINER_SIZE: 27;
        static readonly ITEMS_TAG: "Items";
        static readonly EVENT_SET_OPEN_COUNT: 1;
        static readonly OPENING_TICK_LENGTH: 10;
        static readonly COLUMNS: 9;
        static readonly ROWS: 3;
        static readonly MAX_LID_HEIGHT: 0.5;
    }
    type ShulkerBoxBlockEntity_ = ShulkerBoxBlockEntity;
    class SmithingUpgradeWrapper extends Internal.UpgradeWrapperBase<Internal.SmithingUpgradeWrapper, Internal.SmithingUpgradeItem> {
        setShiftClickIntoStorage(shiftClickIntoStorage: boolean): void;
        shouldShiftClickIntoStorage(): boolean;
        getInventory(): io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
        hideSettingsTab(): boolean;
        onAdded(): void;
        onBeforeRemoved(): void;
        set shiftClickIntoStorage(shiftClickIntoStorage: boolean)
        get inventory(): io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler
    }
    type SmithingUpgradeWrapper_ = SmithingUpgradeWrapper;
    interface Short2ByteFunction extends it.unimi.dsi.fastutil.Function<number, number>, Internal.IntUnaryOperator {
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        put(arg0: number, arg1: number): number;
        andThen(arg0: Internal.IntUnaryOperator_): Internal.IntUnaryOperator;
        composeChar(arg0: Internal.Char2ShortFunction_): Internal.Char2ByteFunction;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        defaultReturnValue(arg0: number): void;
        composeObject<T>(arg0: Internal.Object2ShortFunction_<T>): Internal.Object2ByteFunction<T>;
        andThenReference<T>(arg0: Internal.Byte2ReferenceFunction_<T>): Internal.Short2ReferenceFunction<T>;
        abstract get(arg0: number): number;
        andThenDouble(arg0: Internal.Byte2DoubleFunction_): Internal.Short2DoubleFunction;
        composeLong(arg0: Internal.Long2ShortFunction_): Internal.Long2ByteFunction;
        remove(arg0: number): number;
        andThenLong(arg0: Internal.Byte2LongFunction_): Internal.Short2LongFunction;
        compose(arg0: Internal.IntUnaryOperator_): Internal.IntUnaryOperator;
        /**
         * @deprecated
        */
        applyAsInt(arg0: number): number;
        identity(): Internal.IntUnaryOperator;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        composeFloat(arg0: Internal.Float2ShortFunction_): Internal.Float2ByteFunction;
        defaultReturnValue(): number;
        getOrDefault(arg0: number, arg1: number): number;
        composeInt(arg0: Internal.Int2ShortFunction_): Internal.Int2ByteFunction;
        andThenShort(arg0: Internal.Byte2ShortFunction_): Internal.Short2ShortFunction;
        andThenChar(arg0: Internal.Byte2CharFunction_): Internal.Short2CharFunction;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        containsKey(arg0: number): boolean;
        andThenObject<T>(arg0: Internal.Byte2ObjectFunction_<T>): Internal.Short2ObjectFunction<T>;
        apply(arg0: number): number;
        composeReference<T>(arg0: Internal.Reference2ShortFunction_<T>): Internal.Reference2ByteFunction<T>;
        composeDouble(arg0: Internal.Double2ShortFunction_): Internal.Double2ByteFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        size(): number;
        composeByte(arg0: Internal.Byte2ShortFunction_): Internal.Byte2ByteFunction;
        composeShort(arg0: Internal.Short2ShortFunction_): this;
        andThenByte(arg0: Internal.Byte2ByteFunction_): this;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: number): number;
        andThenInt(arg0: Internal.Byte2IntFunction_): Internal.Short2IntFunction;
        clear(): void;
        andThenFloat(arg0: Internal.Byte2FloatFunction_): Internal.Short2FloatFunction;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        (arg0: number): number;
    }
    type Short2ByteFunction_ = Short2ByteFunction;
    interface CustomExpBlock {
        getExpDrop(state: Internal.BlockState_, level: Internal.LevelReader_, randomSource: Internal.RandomSource_, pos: BlockPos_, fortuneLevel: number, silkTouchLevel: number): number;
    }
    type CustomExpBlock_ = CustomExpBlock;
    class WandTurtleUpgrade extends Internal.AbstractTurtleUpgrade {
        constructor(item: Internal.ItemStack_)
        getPersistedData(upgradeData: Internal.CompoundTag_): Internal.CompoundTag;
        useTool(turtle: Internal.ITurtleAccess_, side: Internal.TurtleSide_, verb: Internal.TurtleVerb_, direction: Internal.Direction_): Internal.TurtleCommandResult;
        getItem(): Internal.ItemStack;
        getUpgradeData(stack: Internal.ItemStack_): Internal.CompoundTag;
        static getDefaultAdjective(id: ResourceLocation_): string;
        isItemSuitable(stack: Internal.ItemStack_): boolean;
        getUpgradeItem(upgradeData: Internal.CompoundTag_): Internal.ItemStack;
        get item(): Internal.ItemStack
    }
    type WandTurtleUpgrade_ = WandTurtleUpgrade;
    interface DiscreteVSAccess {
        abstract getXSize(): number;
        abstract getYSize(): number;
        abstract getZSize(): number;
        get XSize(): number
        get YSize(): number
        get ZSize(): number
    }
    type DiscreteVSAccess_ = DiscreteVSAccess;
    interface MobFilter extends Internal.BiPredicate<Internal.MobCategory, Internal.MobSpawnSettings$SpawnerData> {
        idFilter(cx: Internal.Context_, s: string): this;
        abstract test(arg0: Internal.MobCategory_, arg1: Internal.MobSpawnSettings$SpawnerData_): boolean;
        of(cx: Internal.Context_, o: any): this;
        and(arg0: Internal.BiPredicate_<Internal.MobCategory, Internal.MobSpawnSettings$SpawnerData>): Internal.BiPredicate<Internal.MobCategory, Internal.MobSpawnSettings$SpawnerData>;
        test(arg0: any, arg1: any): boolean;
        negate(): Internal.BiPredicate<Internal.MobCategory, Internal.MobSpawnSettings$SpawnerData>;
        or(arg0: Internal.BiPredicate_<Internal.MobCategory, Internal.MobSpawnSettings$SpawnerData>): Internal.BiPredicate<Internal.MobCategory, Internal.MobSpawnSettings$SpawnerData>;
        (arg0: Internal.MobCategory, arg1: Internal.MobSpawnSettings$SpawnerData): boolean;
        readonly ALWAYS_FALSE: Internal.MobFilter;
        readonly ALWAYS_TRUE: Internal.MobFilter;
    }
    type MobFilter_ = MobFilter | Internal.MobFilter_[] | any_<any> | RegExp | "-" | "*" | `#${Special.EntityTypeTag}` | {tag?: string, id?: any_<any>, type?: any_<any>, not?: Internal.MobFilter_, or?: Internal.MobFilter_};
    interface IntStream$Builder extends Internal.IntConsumer {
        add(arg0: number): this;
        abstract accept(arg0: number): void;
        abstract build(): Internal.IntStream;
        andThen(arg0: Internal.IntConsumer_): Internal.IntConsumer;
    }
    type IntStream$Builder_ = IntStream$Builder;
    class ClearGlassPaneBlock extends Internal.BetterPaneBlock implements Internal.IMultipartConnectedBlock {
        constructor(builder: Internal.BlockBehaviour$Properties_)
        connects(state: Internal.BlockState_, neighbor: Internal.BlockState_): boolean;
        static defaultConnections(state: Internal.BlockState_): Internal.BlockState;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getConnectionUpdate(state: Internal.BlockState_, facing: Internal.Direction_, neighbor: Internal.BlockState_): Internal.BlockState;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        static fillStateContainer(builder: Internal.StateDefinition$Builder_<Internal.Block, Internal.BlockState>): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type ClearGlassPaneBlock_ = ClearGlassPaneBlock;
    class SpawnerBlockEntity extends Internal.BlockEntity {
        constructor($$0: BlockPos_, $$1: Internal.BlockState_)
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getUpdatePacket(): Internal.ClientboundBlockEntityDataPacket;
        getSpawner(): Internal.BaseSpawner;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setEntityId($$0: Internal.EntityType_<any>, $$1: Internal.RandomSource_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getUpdatePacket(): Internal.Packet<any>;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        static serverTick($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.SpawnerBlockEntity_): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        static clientTick($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.SpawnerBlockEntity_): void;
        get updatePacket(): Internal.ClientboundBlockEntityDataPacket
        get spawner(): Internal.BaseSpawner
        get updatePacket(): Internal.Packet<any>
    }
    type SpawnerBlockEntity_ = SpawnerBlockEntity;
    class CookingPotItem extends Internal.BlockItem {
        constructor(block: Internal.Block_, properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type CookingPotItem_ = CookingPotItem;
    class RealmsServerPlayerList extends Internal.ValueObject {
        constructor()
        static parse($$0: Internal.JsonObject_): Internal.RealmsServerPlayerList;
        players: Internal.List<string>;
        serverId: number;
    }
    type RealmsServerPlayerList_ = RealmsServerPlayerList;
    class PortalForcer implements Internal.ITeleporter {
        constructor($$0: Internal.ServerLevel_)
        findPortalAround(centerPos: BlockPos_, dstIsNether: boolean, worldBorder: Internal.WorldBorder_): Internal.Optional<any>;
        isVanilla(): boolean;
        playTeleportSound(player: Internal.ServerPlayer_, sourceWorld: Internal.ServerLevel_, destWorld: Internal.ServerLevel_): boolean;
        getPortalInfo(entity: Internal.Entity_, destWorld: Internal.ServerLevel_, defaultPortalInfo: Internal.Function_<Internal.ServerLevel, Internal.PortalInfo>): Internal.PortalInfo;
        createPortal($$0: BlockPos_, $$1: Internal.Direction$Axis_): Internal.Optional<Internal.BlockUtil$FoundRectangle>;
        placeEntity(entity: Internal.Entity_, currentWorld: Internal.ServerLevel_, destWorld: Internal.ServerLevel_, yaw: number, repositionEntity: Internal.Function_<boolean, Internal.Entity>): Internal.Entity;
        get vanilla(): boolean
    }
    type PortalForcer_ = PortalForcer;
    interface Short2ObjectFunction <V> extends Internal.IntFunction<V>, it.unimi.dsi.fastutil.Function<number, V> {
        composeDouble(arg0: Internal.Double2ShortFunction_): Internal.Double2ObjectFunction<V>;
        composeByte(arg0: Internal.Byte2ShortFunction_): Internal.Byte2ObjectFunction<V>;
        composeReference<T>(arg0: Internal.Reference2ShortFunction_<T>): Internal.Reference2ObjectFunction<T, V>;
        andThenByte(arg0: Internal.Object2ByteFunction_<V>): Internal.Short2ByteFunction;
        remove(arg0: number): V;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, V>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: V): V;
        andThenLong(arg0: Internal.Object2LongFunction_<V>): Internal.Short2LongFunction;
        apply(arg0: number): V;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        andThenReference<T>(arg0: Internal.Object2ReferenceFunction_<V, T>): Internal.Short2ReferenceFunction<T>;
        andThenShort(arg0: Internal.Object2ShortFunction_<V>): Internal.Short2ShortFunction;
        getOrDefault(arg0: number, arg1: V): V;
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<number, V>;
        composeChar(arg0: Internal.Char2ShortFunction_): Internal.Char2ObjectFunction<V>;
        /**
         * @deprecated
        */
        get(arg0: any): V;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        /**
         * @deprecated
        */
        apply(arg0: number): V;
        /**
         * @deprecated
        */
        remove(arg0: any): V;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: V): V;
        composeLong(arg0: Internal.Long2ShortFunction_): Internal.Long2ObjectFunction<V>;
        andThenInt(arg0: Internal.Object2IntFunction_<V>): Internal.Short2IntFunction;
        andThenDouble(arg0: Internal.Object2DoubleFunction_<V>): Internal.Short2DoubleFunction;
        andThenFloat(arg0: Internal.Object2FloatFunction_<V>): Internal.Short2FloatFunction;
        composeFloat(arg0: Internal.Float2ShortFunction_): Internal.Float2ObjectFunction<V>;
        containsKey(arg0: number): boolean;
        composeObject<T>(arg0: Internal.Object2ShortFunction_<T>): Internal.Object2ObjectFunction<T, V>;
        andThenChar(arg0: Internal.Object2CharFunction_<V>): Internal.Short2CharFunction;
        put(arg0: number, arg1: V): V;
        size(): number;
        andThenObject<T>(arg0: Internal.Object2ObjectFunction_<V, T>): Internal.Short2ObjectFunction<T>;
        abstract get(arg0: number): V;
        composeInt(arg0: Internal.Int2ShortFunction_): Internal.Int2ObjectFunction<V>;
        clear(): void;
        defaultReturnValue(): V;
        identity<T>(): Internal.Function<T, T>;
        defaultReturnValue(arg0: V): void;
        composeShort(arg0: Internal.Short2ShortFunction_): this;
        (arg0: number): V;
    }
    type Short2ObjectFunction_<V> = Short2ObjectFunction<V>;
    abstract class CraftingRecipeBuilder {
        constructor()
        static determineBookCategory($$0: Internal.RecipeCategory_): Internal.CraftingBookCategory;
    }
    type CraftingRecipeBuilder_ = CraftingRecipeBuilder;
    interface SpatialLookupEntry {
        abstract cellKey(): number;
        lightAtPos(x: number, y: number, z: number, pos: BlockPos_, luminance: number): number;
        abstract getDynamicLightLevel(arg0: BlockPos_): number;
    }
    type SpatialLookupEntry_ = SpatialLookupEntry;
    class RandomFeatureConfiguration implements Internal.FeatureConfiguration {
        constructor($$0: Internal.List_<Internal.WeightedPlacedFeature>, $$1: Internal.Holder_<Internal.PlacedFeature>)
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        static readonly CODEC: Internal.Codec<Internal.RandomFeatureConfiguration>;
        readonly features: Internal.List<Internal.WeightedPlacedFeature>;
        readonly defaultFeature: Internal.Holder<Internal.PlacedFeature>;
    }
    type RandomFeatureConfiguration_ = RandomFeatureConfiguration;
    interface InternalInventoryHost {
        abstract saveChanges(): void;
        abstract isClientSide(): boolean;
        abstract onChangeInventory(arg0: Internal.InternalInventory_, arg1: number): void;
        get clientSide(): boolean
    }
    type InternalInventoryHost_ = InternalInventoryHost;
    class AllFanProcessingTypes$HauntingType implements Internal.FanProcessingType {
        constructor()
        canProcess(stack: Internal.ItemStack_, level: Internal.Level_): boolean;
        getPriority(): number;
        morphAirFlow(particleAccess: Internal.FanProcessingType$AirFlowParticleAccess_, random: Internal.RandomSource_): void;
        isValidAt(level: Internal.Level_, pos: BlockPos_): boolean;
        static getAt(level: Internal.Level_, pos: BlockPos_): Internal.FanProcessingType;
        process(stack: Internal.ItemStack_, level: Internal.Level_): Internal.List<Internal.ItemStack>;
        static parse(str: string): Internal.FanProcessingType;
        affectEntity(entity: Internal.Entity_, level: Internal.Level_): void;
        spawnProcessingParticles(level: Internal.Level_, pos: Vec3d_): void;
        get priority(): number
    }
    type AllFanProcessingTypes$HauntingType_ = AllFanProcessingTypes$HauntingType;
    class BlockStateMirrorCallbackJS extends Internal.BlockStateModifyCallbackJS {
        constructor(state: Internal.BlockState_, mirror: Internal.Mirror_)
        /**
         * Gets the rotation of the direction passed in relative to this mirror
        */
        getRotation(dir: Internal.Direction_): Internal.Rotation;
        /**
         * Gets the Mirror
        */
        getMirror(): Internal.Mirror;
        /**
         * Mirrors the direction passed in
        */
        mirror(dir: Internal.Direction_): Internal.Direction;
        /**
         * Gets the Mirror
        */
        get mirror(): Internal.Mirror
    }
    type BlockStateMirrorCallbackJS_ = BlockStateMirrorCallbackJS;
    class ClientboundUpdateMobEffectPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: number, $$1: Internal.MobEffectInstance_)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        getEffectDurationTicks(): number;
        isEffectVisible(): boolean;
        getEffect(): Internal.MobEffect;
        write($$0: Internal.FriendlyByteBuf_): void;
        isEffectAmbient(): boolean;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getEntityId(): number;
        getEffectAmplifier(): number;
        effectShowsIcon(): boolean;
        isSkippable(): boolean;
        getFactorData(): Internal.MobEffectInstance$FactorData;
        get effectDurationTicks(): number
        get effectVisible(): boolean
        get effect(): Internal.MobEffect
        get effectAmbient(): boolean
        get entityId(): number
        get effectAmplifier(): number
        get skippable(): boolean
        get factorData(): Internal.MobEffectInstance$FactorData
    }
    type ClientboundUpdateMobEffectPacket_ = ClientboundUpdateMobEffectPacket;
    interface FallingBlockEntityAccessor {
        create$callInit(level: Internal.Level_, x: number, y: number, z: number, state: Internal.BlockState_): Internal.FallingBlockEntity;
    }
    type FallingBlockEntityAccessor_ = FallingBlockEntityAccessor;
    abstract class TypeCapture <T> {
    }
    type TypeCapture_<T> = TypeCapture<T>;
    class LevelLightEngine implements Internal.StarLightLightingProvider, Internal.LightEventListener {
        constructor($$0: Internal.LightChunkGetter_, $$1: boolean, $$2: boolean)
        clientRemoveLightData(chunkPos: Internal.ChunkPos_): void;
        checkBlock(pos: BlockPos_): void;
        getDebugSectionType($$0: Internal.LightLayer_, $$1: Internal.SectionPos_): Internal.LayerLightSectionStorage$SectionType;
        clientChunkLoad(pos: Internal.ChunkPos_, chunk: Internal.LevelChunk_): void;
        getDebugData(lightType: Internal.LightLayer_, pos: Internal.SectionPos_): string;
        updateSectionStatus($$0: BlockPos_, $$1: boolean): void;
        retainData(pos: Internal.ChunkPos_, retainData: boolean): void;
        handler$hja000$starlight$construct(chunkProvider: Internal.LightChunkGetter_, hasBlockLight: boolean, hasSkyLight: boolean, ci: Internal.CallbackInfo_): void;
        lightOnInSection(pos: Internal.SectionPos_): boolean;
        getLightSectionCount(): number;
        getMaxLightSection(): number;
        propagateLightSources(param0: Internal.ChunkPos_): void;
        getLayerListener(lightType: Internal.LightLayer_): Internal.LayerLightEventListener;
        runLightUpdates(): number;
        setLightEnabled(pos: Internal.ChunkPos_, lightEnabled: boolean): void;
        getLightEngine(): Internal.StarLightInterface;
        getMinLightSection(): number;
        "handler$hgg000$sodium-extra$checkBlock"(pos: BlockPos_, ci: Internal.CallbackInfo_): void;
        clientUpdateLight(lightType: Internal.LightLayer_, pos: Internal.SectionPos_, nibble: Internal.DataLayer_, trustEdges: boolean): void;
        "handler$hgg000$sodium-extra$doLightUpdates"(cir: Internal.CallbackInfoReturnable_<any>): void;
        hasLightWork(): boolean;
        queueSectionData(lightType: Internal.LightLayer_, pos: Internal.SectionPos_, nibble: Internal.DataLayer_): void;
        getRawBrightness(pos: BlockPos_, ambientDarkness: number): number;
        updateSectionStatus(pos: Internal.SectionPos_, notReady: boolean): void;
        get lightSectionCount(): number
        get maxLightSection(): number
        get lightEngine(): Internal.StarLightInterface
        get minLightSection(): number
        static readonly LIGHT_SECTION_PADDING: 1;
    }
    type LevelLightEngine_ = LevelLightEngine;
    class BeaconLightBehavior extends Internal.Record implements Internal.DynamicLightBehavior {
        constructor(x: number, z: number, luminance: number, level: Internal.Level_)
        constructor(x: number, y: Internal.OptionalInt_, z: number, luminance: number, level: Internal.Level_)
        y(): Internal.OptionalInt;
        getBoundingBox(): Internal.DynamicLightBehavior$BoundingBox;
        lightAtPos(pos: BlockPos_, falloffRatio: number): number;
        hasChanged(): boolean;
        isRemoved(): boolean;
        level(): Internal.Level;
        z(): number;
        x(): number;
        luminance(): number;
        get boundingBox(): Internal.DynamicLightBehavior$BoundingBox
        get removed(): boolean
    }
    type BeaconLightBehavior_ = BeaconLightBehavior;
    /**
     * Invoked when the game is starting up and the item tool tiers are being registered.
    */
    class ItemToolTierRegistryEventJS extends Internal.StartupEventJS {
        constructor()
        /**
         * Adds a new tool tier.
        */
        add(id: string, tier: Internal.Consumer_<Internal.MutableToolTier>): void;
    }
    type ItemToolTierRegistryEventJS_ = ItemToolTierRegistryEventJS;
    class AEBaseBlockItem extends Internal.BlockItem {
        constructor(id: Internal.Block_, props: Internal.Item$Properties_)
        addCheckedInformation(itemStack: Internal.ItemStack_, level: Internal.Level_, toolTip: Internal.List_<net.minecraft.network.chat.Component>, advancedTooltips: Internal.TooltipFlag_): void;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type AEBaseBlockItem_ = AEBaseBlockItem;
    class CableBlockItem$WiredModem extends Internal.CableBlockItem {
        constructor(block: dan200.computercraft.shared.peripheral.modem.wired.CableBlock_, settings: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type CableBlockItem$WiredModem_ = CableBlockItem$WiredModem;
    class ClientboundOpenSignEditorPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: BlockPos_, $$1: boolean)
        handle(arg0: Internal.PacketListener_): void;
        getPos(): BlockPos;
        write($$0: Internal.FriendlyByteBuf_): void;
        isFrontText(): boolean;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        get pos(): BlockPos
        get frontText(): boolean
        get skippable(): boolean
    }
    type ClientboundOpenSignEditorPacket_ = ClientboundOpenSignEditorPacket;
    class HexalRecipeTypes$Companion$registerType$type$1 implements Internal.RecipeType<T> {
        static register<T extends Internal.Recipe<any>>($$0: string): Internal.RecipeType<T>;
    }
    type HexalRecipeTypes$Companion$registerType$type$1_ = HexalRecipeTypes$Companion$registerType$type$1;
    class WriteBufferWaterMark {
        constructor(arg0: number, arg1: number)
        low(): number;
        high(): number;
        static readonly DEFAULT: Internal.WriteBufferWaterMark;
    }
    type WriteBufferWaterMark_ = WriteBufferWaterMark;
    class HugeMushroomBlock extends Internal.Block {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly NORTH: Internal.BooleanProperty;
        static readonly SOUTH: Internal.BooleanProperty;
        static readonly UP: Internal.BooleanProperty;
        static readonly WEST: Internal.BooleanProperty;
        static readonly DOWN: Internal.BooleanProperty;
        static readonly EAST: Internal.BooleanProperty;
    }
    type HugeMushroomBlock_ = HugeMushroomBlock;
    class AllArmInteractionPointTypes$MillstoneType extends Internal.ArmInteractionPointType {
        constructor()
    }
    type AllArmInteractionPointTypes$MillstoneType_ = AllArmInteractionPointTypes$MillstoneType;
    abstract class GraphicsDevice {
        isFullScreenSupported(): boolean;
        isDisplayChangeSupported(): boolean;
        getFullScreenWindow(): Internal.Window;
        setDisplayMode(arg0: Internal.DisplayMode_): void;
        isWindowTranslucencySupported(arg0: Internal.GraphicsDevice$WindowTranslucency_): boolean;
        getDisplayModes(): Internal.DisplayMode[];
        abstract getIDstring(): string;
        getDisplayMode(): Internal.DisplayMode;
        getBestConfiguration(arg0: Internal.GraphicsConfigTemplate_): Internal.GraphicsConfiguration;
        abstract getType(): number;
        getAvailableAcceleratedMemory(): number;
        abstract getConfigurations(): Internal.GraphicsConfiguration[];
        setFullScreenWindow(arg0: Internal.Window_): void;
        abstract getDefaultConfiguration(): Internal.GraphicsConfiguration;
        get fullScreenSupported(): boolean
        get displayChangeSupported(): boolean
        get fullScreenWindow(): Internal.Window
        set displayMode(arg0: Internal.DisplayMode_)
        get displayModes(): Internal.DisplayMode[]
        get IDstring(): string
        get displayMode(): Internal.DisplayMode
        get type(): number
        get availableAcceleratedMemory(): number
        get configurations(): Internal.GraphicsConfiguration[]
        set fullScreenWindow(arg0: Internal.Window_)
        get defaultConfiguration(): Internal.GraphicsConfiguration
        static readonly TYPE_PRINTER: 1;
        static readonly TYPE_IMAGE_BUFFER: 2;
        static readonly TYPE_RASTER_SCREEN: 0;
    }
    type GraphicsDevice_ = GraphicsDevice;
    interface ServerLevelData extends Internal.WritableLevelData {
        abstract setInitialized(arg0: boolean): void;
        abstract setWanderingTraderSpawnDelay(arg0: number): void;
        abstract setRainTime(arg0: number): void;
        abstract getWanderingTraderSpawnChance(): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        abstract setWanderingTraderSpawnChance(arg0: number): void;
        abstract isRaining(): boolean;
        abstract getLevelName(): string;
        abstract getSpawnAngle(): number;
        abstract getThunderTime(): number;
        abstract isHardcore(): boolean;
        abstract getYSpawn(): number;
        abstract setClearWeatherTime(arg0: number): void;
        abstract getZSpawn(): number;
        abstract setThundering(arg0: boolean): void;
        abstract getXSpawn(): number;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        abstract setWanderingTraderId(arg0: Internal.UUID_): void;
        abstract getDifficulty(): Internal.Difficulty;
        abstract isThundering(): boolean;
        abstract isDifficultyLocked(): boolean;
        asComponentProvider(): Internal.ComponentProvider;
        getRecipientsForComponentSync(): Internal.Iterable<Internal.ServerPlayer>;
        abstract setDayTime(arg0: number): void;
        abstract setXSpawn(arg0: number): void;
        abstract getWanderingTraderSpawnDelay(): number;
        abstract setThunderTime(arg0: number): void;
        abstract setZSpawn(arg0: number): void;
        abstract getWorldBorder(): Internal.WorldBorder$Settings;
        abstract getClearWeatherTime(): number;
        abstract getRainTime(): number;
        abstract getComponentContainer(): Internal.ComponentContainer;
        abstract getGameType(): Internal.GameType;
        abstract setGameTime(arg0: number): void;
        abstract setWorldBorder(arg0: Internal.WorldBorder$Settings_): void;
        fillCrashReportCategory($$0: Internal.CrashReportCategory_, $$1: Internal.LevelHeightAccessor_): void;
        toComponentPacket<C extends Internal.AutoSyncedComponent>(key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        abstract setRaining(arg0: boolean): void;
        abstract getGameRules(): Internal.GameRules;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        abstract getWanderingTraderId(): Internal.UUID;
        abstract isInitialized(): boolean;
        abstract getGameTime(): number;
        abstract getAllowCommands(): boolean;
        abstract getScheduledEvents(): Internal.TimerQueue<Internal.MinecraftServer>;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        abstract setYSpawn(arg0: number): void;
        abstract setGameType(arg0: Internal.GameType_): void;
        setSpawn($$0: BlockPos_, $$1: number): void;
        abstract setSpawnAngle(arg0: number): void;
        abstract getDayTime(): number;
        set initialized(arg0: boolean)
        set wanderingTraderSpawnDelay(arg0: number)
        set rainTime(arg0: number)
        get wanderingTraderSpawnChance(): number
        set wanderingTraderSpawnChance(arg0: number)
        get raining(): boolean
        get levelName(): string
        get spawnAngle(): number
        get thunderTime(): number
        get hardcore(): boolean
        get YSpawn(): number
        set clearWeatherTime(arg0: number)
        get ZSpawn(): number
        set thundering(arg0: boolean)
        get XSpawn(): number
        set wanderingTraderId(arg0: Internal.UUID_)
        get difficulty(): Internal.Difficulty
        get thundering(): boolean
        get difficultyLocked(): boolean
        get recipientsForComponentSync(): Internal.Iterable<Internal.ServerPlayer>
        set dayTime(arg0: number)
        set XSpawn(arg0: number)
        get wanderingTraderSpawnDelay(): number
        set thunderTime(arg0: number)
        set ZSpawn(arg0: number)
        get worldBorder(): Internal.WorldBorder$Settings
        get clearWeatherTime(): number
        get rainTime(): number
        get componentContainer(): Internal.ComponentContainer
        get gameType(): Internal.GameType
        set gameTime(arg0: number)
        set worldBorder(arg0: Internal.WorldBorder$Settings_)
        set raining(arg0: boolean)
        get gameRules(): Internal.GameRules
        get wanderingTraderId(): Internal.UUID
        get initialized(): boolean
        get gameTime(): number
        get allowCommands(): boolean
        get scheduledEvents(): Internal.TimerQueue<Internal.MinecraftServer>
        set YSpawn(arg0: number)
        set gameType(arg0: Internal.GameType_)
        set spawnAngle(arg0: number)
        get dayTime(): number
    }
    type ServerLevelData_ = ServerLevelData;
    interface TypeDescJS {
        fixedArray(...types: Internal.TypeDescJS_[]): this;
        build(): string;
        abstract build(arg0: Internal.StringBuilder_): void;
        or(type: Internal.TypeDescJS_): this;
        object(): Internal.ObjectDescJS;
        asMap(): this;
        asArray(): this;
        any(...types: Internal.TypeDescJS_[]): this;
        asMap(key: Internal.TypeDescJS_): this;
        withGenerics(...types: Internal.TypeDescJS_[]): this;
        object(init: number): Internal.ObjectDescJS;
        (arg0: Internal.StringBuilder): void;
        readonly ANY_MAP: Internal.GenericDescJS;
        readonly MAP: Internal.PrimitiveDescJS;
        readonly NULL: Internal.PrimitiveDescJS;
        readonly STRING: Internal.PrimitiveDescJS;
        readonly BOOLEAN: Internal.PrimitiveDescJS;
        readonly NUMBER: Internal.PrimitiveDescJS;
        readonly ANY: Internal.PrimitiveDescJS;
    }
    type TypeDescJS_ = TypeDescJS;
    interface IndexSequence {
        abstract fill(arg0: number, arg1: number): void;
        (arg0: number, arg1: number): void;
    }
    type IndexSequence_ = IndexSequence;
    class InscriberBlock extends Internal.AEBaseEntityBlock<any> implements Internal.SimpleWaterloggedBlock {
        constructor(props: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type InscriberBlock_ = InscriberBlock;
    class OnionBlock extends Internal.CropBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type OnionBlock_ = OnionBlock;
    class SoundKeyframeData extends Internal.KeyFrameData {
        constructor(startTick: number, sound: string)
        getSound(): string;
        get sound(): string
    }
    type SoundKeyframeData_ = SoundKeyframeData;
    class PostChain implements Internal.AutoCloseable {
        constructor($$0: Internal.TextureManager_, $$1: Internal.ResourceManager_, $$2: Internal.RenderTarget_, $$3: ResourceLocation_)
        process($$0: number): void;
        addPass($$0: string, $$1: Internal.RenderTarget_, $$2: Internal.RenderTarget_): Internal.PostPass;
        close(): void;
        getName(): string;
        resize($$0: number, $$1: number): void;
        addTempTarget($$0: string, $$1: number, $$2: number): void;
        getTempTarget($$0: string): Internal.RenderTarget;
        handler$zgc000$porting_lib_base$port_lib$isStencil(name: string, width: number, height: number, ci: Internal.CallbackInfo_, rendertarget: Internal.RenderTarget_): void;
        get name(): string
        readonly passes: Internal.List<Internal.PostPass>;
    }
    type PostChain_ = PostChain;
    interface EntityEvents$Remove {
        abstract onRemove(arg0: Internal.Entity_, arg1: Internal.Entity$RemovalReason_): void;
        (arg0: Internal.Entity, arg1: Internal.Entity$RemovalReason): void;
    }
    type EntityEvents$Remove_ = EntityEvents$Remove;
    interface OwoSlotExtension {
        abstract owo$setDisabledOverride(arg0: boolean): void;
        abstract owo$getScissorArea(): Internal.PositionedRectangle;
        abstract owo$getDisabledOverride(): boolean;
        abstract owo$setScissorArea(arg0: Internal.PositionedRectangle_): void;
    }
    type OwoSlotExtension_ = OwoSlotExtension;
    class DragonHoverPhase extends Internal.AbstractDragonPhaseInstance {
        constructor($$0: Internal.EnderDragon_)
        getPhase(): Internal.EnderDragonPhase<Internal.DragonHoverPhase>;
        get phase(): Internal.EnderDragonPhase<Internal.DragonHoverPhase>
    }
    type DragonHoverPhase_ = DragonHoverPhase;
    class BooleanIota$1 extends Internal.IotaType<Internal.BooleanIota> {
        deserialize(tag: Internal.Tag_, world: Internal.ServerLevel_): Internal.BooleanIota;
    }
    type BooleanIota$1_ = BooleanIota$1;
    class StemBlock extends Internal.BushBlock implements Internal.IPlantable, Internal.BonemealableBlock {
        constructor($$0: Internal.StemGrownBlock_, $$1: Internal.Supplier_<Internal.Item>, $$2: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        isBonemealSuccess($$0: Internal.Level_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        performBonemeal($$0: Internal.ServerLevel_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): void;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        isValidBonemealTarget($$0: Internal.LevelReader_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: boolean): boolean;
        setLightEmission(v: number): void;
        getMod(): string;
        getPlant(world: Internal.BlockGetter_, pos: BlockPos_): Internal.BlockState;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        handler$bec001$balm$mayPlaceOn(state: Internal.BlockState_, blockGetter: Internal.BlockGetter_, pos: BlockPos_, callbackInfo: Internal.CallbackInfoReturnable_<any>): void;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        handler$bdj001$balm$randomTickPreGrow(state: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, random: Internal.RandomSource_, callbackInfo: Internal.CallbackInfo_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        handler$bdj000$balm$randomTickPostGrow2(state: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, random: Internal.RandomSource_, callbackInfo: Internal.CallbackInfo_): void;
        getFruit(): Internal.StemGrownBlock;
        arch$holder(): Internal.Holder<Internal.Block>;
        handler$bdj001$balm$randomTickPostGrow(state: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, random: Internal.RandomSource_, callbackInfo: Internal.CallbackInfo_): void;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get fruit(): Internal.StemGrownBlock
        static readonly AGE: Internal.IntegerProperty;
        static readonly MAX_AGE: 7;
    }
    type StemBlock_ = StemBlock;
    class ItemModBook extends Internal.Item {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        static forBook(book: Internal.Book_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        static forBook(book: ResourceLocation_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        static getBook(stack: Internal.ItemStack_): Internal.Book;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        static getCompletion(stack: Internal.ItemStack_): number;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly TAG_BOOK: "patchouli:book";
    }
    type ItemModBook_ = ItemModBook;
    interface AccessibleAction {
        abstract getAccessibleActionDescription(arg0: number): string;
        abstract getAccessibleActionCount(): number;
        abstract doAccessibleAction(arg0: number): boolean;
        get accessibleActionCount(): number
        readonly TOGGLE_EXPAND: "toggleexpand";
        readonly INCREMENT: "increment";
        readonly DECREMENT: "decrement";
        readonly CLICK: "click";
        readonly TOGGLE_POPUP: "toggle popup";
    }
    type AccessibleAction_ = AccessibleAction;
    interface GlyphProvider extends Internal.AutoCloseable {
        close(): void;
        getGlyph($$0: number): Internal.GlyphInfo;
        abstract getSupportedGlyphs(): Internal.IntSet;
        get supportedGlyphs(): Internal.IntSet
        (): Internal.IntSet_;
    }
    type GlyphProvider_ = GlyphProvider;
    class ItemDragonArmor extends Internal.Item {
        constructor(type: Internal.DragonArmorMaterial_, dragonSlot: Internal.DragonArmorPart_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        name: string;
        readonly type: Internal.DragonArmorMaterial;
        readonly dragonSlot: Internal.DragonArmorPart;
    }
    type ItemDragonArmor_ = ItemDragonArmor;
    class BlockUtil$FoundRectangle {
        constructor($$0: BlockPos_, $$1: number, $$2: number)
        readonly minCorner: BlockPos;
        readonly axis2Size: number;
        readonly axis1Size: number;
    }
    type BlockUtil$FoundRectangle_ = BlockUtil$FoundRectangle;
    interface EventExecutorGroup extends Internal.Iterable<Internal.EventExecutor>, Internal.ScheduledExecutorService {
        abstract invokeAll<T>(arg0: Internal.Collection_<Internal.Callable<T>>, arg1: number, arg2: Internal.TimeUnit_): Internal.List<Internal.Future<T>>;
        abstract submit<T>(arg0: Internal.Runnable_, arg1: T): io.netty.util.concurrent.Future<T>;
        abstract scheduleAtFixedRate(arg0: Internal.Runnable_, arg1: number, arg2: number, arg3: Internal.TimeUnit_): io.netty.util.concurrent.ScheduledFuture<any>;
        spliterator(): Internal.Spliterator<Internal.EventExecutor>;
        abstract schedule<V>(arg0: Internal.Callable_<V>, arg1: number, arg2: Internal.TimeUnit_): io.netty.util.concurrent.ScheduledFuture<V>;
        abstract next(): Internal.EventExecutor;
        abstract isTerminated(): boolean;
        abstract invokeAny<T>(arg0: Internal.Collection_<Internal.Callable<T>>, arg1: number, arg2: Internal.TimeUnit_): T;
        abstract scheduleWithFixedDelay(arg0: Internal.Runnable_, arg1: number, arg2: number, arg3: Internal.TimeUnit_): io.netty.util.concurrent.ScheduledFuture<any>;
        abstract isShutdown(): boolean;
        /**
         * @deprecated
        */
        abstract shutdownNow(): Internal.List<Internal.Runnable>;
        abstract invokeAll<T>(arg0: Internal.Collection_<Internal.Callable<T>>): Internal.List<Internal.Future<T>>;
        abstract shutdownGracefully(arg0: number, arg1: number, arg2: Internal.TimeUnit_): io.netty.util.concurrent.Future<any>;
        abstract shutdownGracefully(): io.netty.util.concurrent.Future<any>;
        /**
         * @deprecated
        */
        abstract shutdown(): void;
        abstract terminationFuture(): io.netty.util.concurrent.Future<any>;
        abstract iterator(): Internal.Iterator<Internal.EventExecutor>;
        abstract awaitTermination(arg0: number, arg1: Internal.TimeUnit_): boolean;
        forEach(arg0: Internal.Consumer_<Internal.EventExecutor>): void;
        abstract schedule(arg0: Internal.Runnable_, arg1: number, arg2: Internal.TimeUnit_): io.netty.util.concurrent.ScheduledFuture<any>;
        close(): void;
        abstract invokeAny<T>(arg0: Internal.Collection_<Internal.Callable<T>>): T;
        abstract execute(arg0: Internal.Runnable_): void;
        abstract submit(arg0: Internal.Runnable_): io.netty.util.concurrent.Future<any>;
        abstract submit<T>(arg0: Internal.Callable_<T>): io.netty.util.concurrent.Future<T>;
        abstract isShuttingDown(): boolean;
        get terminated(): boolean
        get shutdown(): boolean
        get shuttingDown(): boolean
    }
    type EventExecutorGroup_ = EventExecutorGroup;
    class TrackSwitchBlockImpl extends Internal.TrackSwitchBlock implements Internal.WeakPowerCheckingBlock, Internal.ConnectableRedstoneBlock {
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.TrackSwitchBlockEntity>;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.TrackSwitchBlockEntity;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        canConnectRedstone(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, side: Internal.Direction_): boolean;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.TrackSwitchBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        shouldCheckWeakPower(state: Internal.BlockState_, world: Internal.SignalGetter_, pos: BlockPos_, side: Internal.Direction_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.TrackSwitchBlockEntity>): void;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type TrackSwitchBlockImpl_ = TrackSwitchBlockImpl;
    interface ISpatialService extends Internal.IGridService {
        abstract getLevel(): Internal.Level;
        abstract requiredPower(): number;
        abstract isValidRegion(): boolean;
        abstract getMax(): BlockPos;
        abstract hasRegion(): boolean;
        abstract getMin(): BlockPos;
        abstract currentEfficiency(): number;
        get level(): Internal.Level
        get validRegion(): boolean
        get max(): BlockPos
        get min(): BlockPos
    }
    type ISpatialService_ = ISpatialService;
    interface ResourceOrTagArgument$Result <T> extends Internal.Predicate<Internal.Holder<T>> {
        not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
        abstract test(arg0: Internal.Holder_<T>): boolean;
        abstract cast<E>(arg0: Internal.ResourceKey_<Internal.Registry<E>>): Internal.Optional<Internal.ResourceOrTagArgument$Result<E>>;
        negate(): Internal.Predicate<Internal.Holder<T>>;
        abstract asPrintable(): string;
        abstract unwrap(): Internal.Either<Internal.Holder$Reference<T>, Internal.HolderSet$Named<T>>;
        or(arg0: Internal.Predicate_<Internal.Holder<T>>): Internal.Predicate<Internal.Holder<T>>;
        and(arg0: Internal.Predicate_<Internal.Holder<T>>): Internal.Predicate<Internal.Holder<T>>;
        isEqual<T>(arg0: any): Internal.Predicate<T>;
    }
    type ResourceOrTagArgument$Result_<T> = ResourceOrTagArgument$Result<T>;
    interface UpdateReceiver {
        abstract invalidateCacheOnNeighborUpdate(arg0: Internal.Direction_): void;
        abstract invalidateCacheOnNeighborUpdate(arg0: boolean): void;
    }
    type UpdateReceiver_ = UpdateReceiver;
    class Program$Type extends Internal.Enum<Internal.Program$Type> implements Internal.ProgramTypeAccessor {
        getExtension(): string;
        static createProgramType(name: string, ordinal: number, typeName: string, extension: string, glId: number): Internal.Program$Type;
        getPrograms(): Internal.Map<string, Internal.Program>;
        static createProgramType$iris_$md$fca01f$0(arg0: string, arg1: number, arg2: string, arg3: string, arg4: number): Internal.Program$Type;
        static values(): Internal.Program$Type[];
        getName(): string;
        static valueOf($$0: string): Internal.Program$Type;
        get extension(): string
        get programs(): Internal.Map<string, Internal.Program>
        get name(): string
        static readonly FRAGMENT: Internal.Program$Type;
        static readonly VERTEX: Internal.Program$Type;
    }
    type Program$Type_ = "vertex" | "geometry" | "tess_eval" | "fragment" | Program$Type | "tess_control";
    interface JsonDeserializer <T> {
        abstract deserialize(arg0: Internal.JsonElement_, arg1: Internal.Type_, arg2: Internal.JsonDeserializationContext_): T;
        (arg0: Internal.JsonElement, arg1: Internal.Type, arg2: Internal.JsonDeserializationContext): T;
    }
    type JsonDeserializer_<T> = JsonDeserializer<T>;
    class WallHangingCanvasSignBlock extends Internal.WallHangingSignBlock implements Internal.CanvasSign {
        constructor(properties: Internal.BlockBehaviour$Properties_, backgroundColor: Internal.DyeColor_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        isDarkBackground(): boolean;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getBackgroundColor(): Internal.DyeColor;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get darkBackground(): boolean
        get mod(): string
        set destroySpeed(v: number)
        get backgroundColor(): Internal.DyeColor
    }
    type WallHangingCanvasSignBlock_ = WallHangingCanvasSignBlock;
    class ProjectileImpactEvent extends Internal.EntityEvents {
        constructor(projectile: Internal.Projectile_, ray: Internal.HitResult_)
        getProjectile(): Internal.Projectile;
        getRayTraceResult(): Internal.HitResult;
        /**
         * @deprecated
        */
        getImpactResult(): Internal.ProjectileImpactEvent$ImpactResult;
        /**
         * @deprecated
        */
        setImpactResult(result: Internal.ProjectileImpactEvent$ImpactResult_): void;
        get projectile(): Internal.Projectile
        get rayTraceResult(): Internal.HitResult
        /**
         * @deprecated
        */
        get impactResult(): Internal.ProjectileImpactEvent$ImpactResult
        /**
         * @deprecated
        */
        set impactResult(result: Internal.ProjectileImpactEvent$ImpactResult_)
    }
    type ProjectileImpactEvent_ = ProjectileImpactEvent;
    class MainSetting <T> {
        constructor(tagName: string, getValue: Internal.BiFunction_<Internal.CompoundTag, string, Internal.Optional<T>>, setValue: any_<Internal.CompoundTag, string, T>, defaultValue: T)
        setValue(tag: Internal.CompoundTag_, value: T): void;
        getName(): string;
        getValue(tag: Internal.CompoundTag_): Internal.Optional<T>;
        removeFrom(tag: Internal.CompoundTag_): void;
        getDefaultValue(): T;
        get name(): string
        get defaultValue(): T
    }
    type MainSetting_<T> = MainSetting<T>;
    interface Table <R, C, V> {
        abstract putAll(arg0: Internal.Table_<R, C, V>): void;
        abstract values(): Internal.Collection<V>;
        abstract containsValue(arg0: any): boolean;
        abstract cellSet(): Internal.Set<Internal.Table$Cell<R, C, V>>;
        abstract column(arg0: C): Internal.Map<R, V>;
        abstract rowMap(): Internal.Map<R, Internal.Map<C, V>>;
        abstract isEmpty(): boolean;
        abstract remove(arg0: any, arg1: any): V;
        abstract size(): number;
        abstract put(arg0: R, arg1: C, arg2: V): V;
        abstract hashCode(): number;
        abstract columnKeySet(): Internal.Set<C>;
        abstract clear(): void;
        abstract contains(arg0: any, arg1: any): boolean;
        abstract rowKeySet(): Internal.Set<R>;
        abstract row(arg0: R): Internal.Map<C, V>;
        abstract containsRow(arg0: any): boolean;
        abstract equals(arg0: any): boolean;
        abstract get(arg0: any, arg1: any): V;
        abstract columnMap(): Internal.Map<C, Internal.Map<R, V>>;
        abstract containsColumn(arg0: any): boolean;
        get empty(): boolean
    }
    type Table_<R, C, V> = Table<R, C, V>;
    class ILinkable$Companion {
        static readonly MAX_RECEIVED_IOTAS: 64;
    }
    type ILinkable$Companion_ = ILinkable$Companion;
    interface ILecternBookItem {
        abstract openLecternScreenClient(arg0: BlockPos_, arg1: Internal.ItemStack_): void;
        openLecternScreen(world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, book: Internal.ItemStack_): boolean;
        (arg0: BlockPos, arg1: Internal.ItemStack): void;
    }
    type ILecternBookItem_ = ILecternBookItem;
    class AbuseReportRequest {
        constructor(arg0: number, arg1: Internal.UUID_, arg2: Internal.AbuseReport_, arg3: Internal.AbuseReportRequest$ClientInfo_, arg4: Internal.AbuseReportRequest$ThirdPartyServerInfo_, arg5: Internal.AbuseReportRequest$RealmInfo_)
        id: Internal.UUID;
        report: Internal.AbuseReport;
        version: number;
        clientInfo: Internal.AbuseReportRequest$ClientInfo;
        thirdPartyServerInfo: Internal.AbuseReportRequest$ThirdPartyServerInfo;
        realmInfo: Internal.AbuseReportRequest$RealmInfo;
    }
    type AbuseReportRequest_ = AbuseReportRequest;
    class AudioFormat {
        constructor(arg0: Internal.AudioFormat$Encoding_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean)
        constructor(arg0: Internal.AudioFormat$Encoding_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Internal.Map_<string, any>)
        constructor(arg0: number, arg1: number, arg2: number, arg3: boolean, arg4: boolean)
        matches(arg0: Internal.AudioFormat_): boolean;
        properties(): Internal.Map<string, any>;
        getSampleRate(): number;
        getFrameSize(): number;
        getFrameRate(): number;
        getProperty(arg0: string): any;
        isBigEndian(): boolean;
        getEncoding(): Internal.AudioFormat$Encoding;
        getChannels(): number;
        getSampleSizeInBits(): number;
        get sampleRate(): number
        get frameSize(): number
        get frameRate(): number
        get bigEndian(): boolean
        get encoding(): Internal.AudioFormat$Encoding
        get channels(): number
        get sampleSizeInBits(): number
    }
    type AudioFormat_ = AudioFormat;
    class FreezeRecipe$Serializer extends Internal.RecipeSerializerBase<Internal.FreezeRecipe> {
        constructor()
        toNetwork(buf: Internal.FriendlyByteBuf_, recipe: Internal.FreezeRecipe_): void;
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(resourceLocation: ResourceLocation_, jsonObject: Internal.JsonObject_): Internal.Recipe<any>;
        fromJson(recipeID: ResourceLocation_, json: Internal.JsonObject_): Internal.FreezeRecipe;
        fromNetwork(recipeID: ResourceLocation_, buf: Internal.FriendlyByteBuf_): Internal.FreezeRecipe;
        fromNetwork(resourceLocation: ResourceLocation_, friendlyByteBuf: Internal.FriendlyByteBuf_): Internal.Recipe<any>;
    }
    type FreezeRecipe$Serializer_ = FreezeRecipe$Serializer;
    interface IArmorFinder extends Internal.Equipable {
        abstract getEquipmentSlot(): Internal.EquipmentSlot;
        isEquipped(player: Internal.LivingEntity_, stack: Internal.ItemStack_): boolean;
        get($$0: Internal.ItemStack_): Internal.Equipable;
        swapWithEquipmentSlot($$0: Internal.Item_, $$1: Internal.Level_, $$2: Internal.Player_, $$3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        getEquipSound(): Internal.SoundEvent;
        isEquipped(player: Internal.LivingEntity_, item: Internal.Item_): boolean;
        get equipmentSlot(): Internal.EquipmentSlot
        get equipSound(): Internal.SoundEvent
        (): Internal.EquipmentSlot_;
    }
    type IArmorFinder_ = IArmorFinder;
    class MoltenSilverFluid$Source extends Internal.MoltenSilverFluid {
        constructor(properties: Internal.ModFlowingFluid$Properties_, block: Internal.Supplier_<Internal.LiquidBlock>)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type MoltenSilverFluid$Source_ = MoltenSilverFluid$Source;
    interface Double2ByteFunction extends it.unimi.dsi.fastutil.Function<number, number>, Internal.DoubleToIntFunction {
        andThenLong(arg0: Internal.Byte2LongFunction_): Internal.Double2LongFunction;
        andThenByte(arg0: Internal.Byte2ByteFunction_): this;
        andThenDouble(arg0: Internal.Byte2DoubleFunction_): Internal.Double2DoubleFunction;
        andThenInt(arg0: Internal.Byte2IntFunction_): Internal.Double2IntFunction;
        andThenFloat(arg0: Internal.Byte2FloatFunction_): Internal.Double2FloatFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        remove(arg0: number): number;
        andThenObject<T>(arg0: Internal.Byte2ObjectFunction_<T>): Internal.Double2ObjectFunction<T>;
        composeChar(arg0: Internal.Char2DoubleFunction_): Internal.Char2ByteFunction;
        put(arg0: number, arg1: number): number;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        andThenReference<T>(arg0: Internal.Byte2ReferenceFunction_<T>): Internal.Double2ReferenceFunction<T>;
        composeInt(arg0: Internal.Int2DoubleFunction_): Internal.Int2ByteFunction;
        andThenShort(arg0: Internal.Byte2ShortFunction_): Internal.Double2ShortFunction;
        composeObject<T>(arg0: Internal.Object2DoubleFunction_<T>): Internal.Object2ByteFunction<T>;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        composeLong(arg0: Internal.Long2DoubleFunction_): Internal.Long2ByteFunction;
        defaultReturnValue(arg0: number): void;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        andThenChar(arg0: Internal.Byte2CharFunction_): Internal.Double2CharFunction;
        defaultReturnValue(): number;
        composeShort(arg0: Internal.Short2DoubleFunction_): Internal.Short2ByteFunction;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: number): number;
        getOrDefault(arg0: number, arg1: number): number;
        apply(arg0: number): number;
        composeReference<T>(arg0: Internal.Reference2DoubleFunction_<T>): Internal.Reference2ByteFunction<T>;
        abstract get(arg0: number): number;
        containsKey(arg0: number): boolean;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        composeByte(arg0: Internal.Byte2DoubleFunction_): Internal.Byte2ByteFunction;
        size(): number;
        clear(): void;
        composeFloat(arg0: Internal.Float2DoubleFunction_): Internal.Float2ByteFunction;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        identity<T>(): Internal.Function<T, T>;
        applyAsInt(arg0: number): number;
        composeDouble(arg0: Internal.Double2DoubleFunction_): this;
        (arg0: number): number;
    }
    type Double2ByteFunction_ = Double2ByteFunction;
    class EffectProgram extends Internal.Program {
        static compileShader($$0: Internal.Program$Type_, $$1: string, $$2: Internal.InputStream_, $$3: string): Internal.EffectProgram;
        attachToEffect($$0: Internal.Effect_): void;
    }
    type EffectProgram_ = EffectProgram;
    class WorldOpenFlows {
        constructor($$0: Internal.Minecraft_, $$1: Internal.LevelStorageSource_)
        recreateWorldData($$0: Internal.LevelStorageSource$LevelStorageAccess_): com.mojang.datafixers.util.Pair<Internal.LevelSettings, Internal.WorldCreationContext>;
        createLevelFromExistingSettings($$0: Internal.LevelStorageSource$LevelStorageAccess_, $$1: Internal.ReloadableServerResources_, $$2: Internal.LayeredRegistryAccess_<Internal.RegistryLayer>, $$3: Internal.WorldData_): void;
        createFreshLevel($$0: string, $$1: Internal.LevelSettings_, $$2: Internal.WorldOptions_, $$3: Internal.Function_<Internal.RegistryAccess, Internal.WorldDimensions>): void;
        loadWorldStem($$0: Internal.LevelStorageSource$LevelStorageAccess_, $$1: boolean): Internal.WorldStem;
        loadLevel($$0: Internal.Screen_, $$1: string): void;
        static confirmWorldCreation($$0: Internal.Minecraft_, $$1: Internal.CreateWorldScreen_, $$2: Internal.Lifecycle_, $$3: Internal.Runnable_, $$4: boolean): void;
    }
    type WorldOpenFlows_ = WorldOpenFlows;
    interface MenuBuilder$MenuFactory <T extends Internal.AbstractContainerMenu> {
        abstract create(arg0: Internal.MenuType_<T>, arg1: number, arg2: Internal.Inventory_): T;
        (arg0: Internal.MenuType<T>, arg1: number, arg2: Internal.Inventory): T;
    }
    type MenuBuilder$MenuFactory_<T extends Internal.AbstractContainerMenu> = MenuBuilder$MenuFactory<T>;
    class OreConfiguration implements Internal.FeatureConfiguration {
        constructor($$0: Internal.RuleTest_, $$1: Internal.BlockState_, $$2: number, $$3: number)
        constructor($$0: Internal.RuleTest_, $$1: Internal.BlockState_, $$2: number)
        constructor($$0: Internal.List_<Internal.OreConfiguration$TargetBlockState>, $$1: number, $$2: number)
        constructor($$0: Internal.List_<Internal.OreConfiguration$TargetBlockState>, $$1: number)
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        static target($$0: Internal.RuleTest_, $$1: Internal.BlockState_): Internal.OreConfiguration$TargetBlockState;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        readonly discardChanceOnAirExposure: number;
        readonly targetStates: Internal.List<Internal.OreConfiguration$TargetBlockState>;
        static readonly CODEC: Internal.Codec<Internal.OreConfiguration>;
        readonly size: number;
    }
    type OreConfiguration_ = OreConfiguration;
    class MechanicalPressBlock extends Internal.HorizontalKineticBlock implements Internal.IBE<Internal.MechanicalPressBlockEntity> {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        getBlockEntityType(): Internal.BlockEntityType<Internal.MechanicalPressBlockEntity>;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.MechanicalPressBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        setRequiresTool(v: boolean): void;
        getBlockEntityClass(): typeof Internal.MechanicalPressBlockEntity;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.MechanicalPressBlockEntity;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.MechanicalPressBlockEntity>;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        showCapacityWithAnnotation(): boolean;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.MechanicalPressBlockEntity>): void;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockEntityType(): Internal.BlockEntityType<Internal.MechanicalPressBlockEntity>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get blockEntityClass(): typeof Internal.MechanicalPressBlockEntity
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
    }
    type MechanicalPressBlock_ = MechanicalPressBlock;
    class HungerLevel extends Internal.Enum<Internal.HungerLevel> implements Internal.StringRepresentable {
        next(): this;
        static valueOf(name: string): Internal.HungerLevel;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static fromName(name: string): Internal.HungerLevel;
        static values(): Internal.HungerLevel[];
        get serializedName(): string
        static readonly FULL: Internal.HungerLevel;
        static readonly ANY: Internal.HungerLevel;
        static readonly HALF: Internal.HungerLevel;
    }
    type HungerLevel_ = HungerLevel | "half" | "any" | "full";
    class ImmutableCollections$Set12 <E> extends Internal.ImmutableCollections$AbstractImmutableSet<E> implements Internal.Serializable {
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.Set<E>;
        forEach(arg0: Internal.Consumer_<E>): void;
        toArray<T>(arg0: T[]): T[];
        parallelStream(): Internal.Stream<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.Set<E>;
        iterator(): Internal.Iterator<E>;
        static of<E>(arg0: E): Internal.Set<E>;
        static of<E>(): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.Set<E>;
        static of<E>(...arg0: E[]): Internal.Set<E>;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        stream(): Internal.Stream<E>;
        static of<E>(arg0: E, arg1: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.Set<E>;
        spliterator(): Internal.Spliterator<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.Set<E>;
        static copyOf<E>(arg0: Internal.Collection_<E>): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.Set<E>;
    }
    type ImmutableCollections$Set12_<E> = ImmutableCollections$Set12<E>;
    class ThrownEnderpearl extends Internal.ThrowableItemProjectile {
        constructor($$0: Internal.EntityType_<Internal.ThrownEnderpearl>, $$1: Internal.Level_)
        constructor($$0: Internal.Level_, $$1: Internal.LivingEntity_)
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        getDistance(pos: BlockPos_): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setRotation(yaw: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        isOnScoreboardTeam(teamId: string): boolean;
        getType(): string;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        self(): Internal.Entity;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        setPosition(x: number, y: number, z: number): void;
        getPassengers(): Internal.EntityArrayList;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isLiving(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        alwaysAccepts(): boolean;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        getDisplayName(): net.minecraft.network.chat.Component;
        setMotionX(x: number): void;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        attack(hp: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTeamId(): string;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        serializeNBT(): Internal.Tag;
        setDynamicLightEnabled(enabled: boolean): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        isFrame(): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getProfile(): Internal.GameProfile;
        playSound(id: Internal.SoundEvent_): void;
        lithiumOnBlockCacheDeleted(): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        runCommand(command: string): number;
        getDistance(x: number, y: number, z: number): number;
        set motionY(y: number)
        get peacefulCreature(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get server(): Internal.MinecraftServer
        get displayName(): net.minecraft.network.chat.Component
        set motionX(x: number)
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get facing(): Internal.Direction
        set dynamicLightEnabled(enabled: boolean)
        get motionX(): number
        get waterCreature(): boolean
        get motionZ(): number
        get item(): Internal.ItemStack
        set x(x: number)
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get frame(): boolean
        get profile(): Internal.GameProfile
    }
    type ThrownEnderpearl_ = ThrownEnderpearl;
    class BlockExInterface extends Internal.BlockBaseGui<Internal.TileExInterface> {
        constructor()
        openGui(tile: Internal.TileExInterface_, p: Internal.Player_): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type BlockExInterface_ = BlockExInterface;
    class MapDecoration implements Internal.MapDecorationExtensions {
        constructor($$0: Internal.MapDecoration$Type_, $$1: number, $$2: number, $$3: number, $$4: net.minecraft.network.chat.Component_)
        getX(): number;
        getRot(): number;
        getName(): net.minecraft.network.chat.Component;
        renderOnFrame(): boolean;
        getImage(): number;
        getType(): Internal.MapDecoration$Type;
        render(index: number): boolean;
        getY(): number;
        get x(): number
        get rot(): number
        get name(): net.minecraft.network.chat.Component
        get image(): number
        get type(): Internal.MapDecoration$Type
        get y(): number
    }
    type MapDecoration_ = MapDecoration;
    class ServerboundKeepAlivePacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: number)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ServerGamePacketListener_): void;
        getId(): number;
        isSkippable(): boolean;
        get id(): number
        get skippable(): boolean
    }
    type ServerboundKeepAlivePacket_ = ServerboundKeepAlivePacket;
    class AccessFlag extends Internal.Enum<Internal.AccessFlag> {
        sourceModifier(): boolean;
        locations(): Internal.Set<Internal.AccessFlag$Location>;
        static valueOf(arg0: string): Internal.AccessFlag;
        static maskToAccessFlags(arg0: number, arg1: Internal.AccessFlag$Location_): Internal.Set<Internal.AccessFlag>;
        mask(): number;
        locations(arg0: Internal.ClassFileFormatVersion_): Internal.Set<Internal.AccessFlag$Location>;
        static values(): Internal.AccessFlag[];
        static readonly VOLATILE: Internal.AccessFlag;
        static readonly INTERFACE: Internal.AccessFlag;
        static readonly MODULE: Internal.AccessFlag;
        static readonly FINAL: Internal.AccessFlag;
        static readonly BRIDGE: Internal.AccessFlag;
        static readonly VARARGS: Internal.AccessFlag;
        static readonly TRANSITIVE: Internal.AccessFlag;
        static readonly STATIC_PHASE: Internal.AccessFlag;
        static readonly PUBLIC: Internal.AccessFlag;
        static readonly PRIVATE: Internal.AccessFlag;
        static readonly PROTECTED: Internal.AccessFlag;
        static readonly NATIVE: Internal.AccessFlag;
        static readonly OPEN: Internal.AccessFlag;
        static readonly SYNCHRONIZED: Internal.AccessFlag;
        static readonly TRANSIENT: Internal.AccessFlag;
        static readonly SUPER: Internal.AccessFlag;
        static readonly STATIC: Internal.AccessFlag;
        static readonly ABSTRACT: Internal.AccessFlag;
        static readonly STRICT: Internal.AccessFlag;
        static readonly SYNTHETIC: Internal.AccessFlag;
        static readonly ANNOTATION: Internal.AccessFlag;
        static readonly ENUM: Internal.AccessFlag;
        static readonly MANDATED: Internal.AccessFlag;
    }
    type AccessFlag_ = "static" | "synchronized" | "open" | "protected" | "module" | "native" | AccessFlag | "strict" | "abstract" | "static_phase" | "volatile" | "transient" | "mandated" | "transitive" | "varargs" | "final" | "annotation" | "public" | "enum" | "synthetic" | "private" | "interface" | "bridge" | "super";
    class DimensionDataStorage {
        constructor($$0: Internal.File_, $$1: Internal.DataFixer_)
        computeIfAbsent<T extends Internal.SavedData>($$0: Internal.Function_<Internal.CompoundTag, T>, $$1: Internal.Supplier_<T>, $$2: string): T;
        get<T extends Internal.SavedData>($$0: Internal.Function_<Internal.CompoundTag, T>, $$1: string): T;
        set($$0: string, $$1: Internal.SavedData_): void;
        readTagFromDisk($$0: string, $$1: number): Internal.CompoundTag;
        save(): void;
    }
    type DimensionDataStorage_ = DimensionDataStorage;
    class StopWatchDisplaySource extends Internal.SingleLineDisplaySource {
        constructor()
    }
    type StopWatchDisplaySource_ = StopWatchDisplaySource;
    class RecipesEventJS extends Internal.EventJS {
        constructor()
        findRecipes(filter: Internal.RecipeFilter_): Internal.Collection<Internal.RecipeJS>;
        custom(json: Internal.JsonObject_): Internal.RecipeJS;
        customFilter(filter: Internal.Predicate_<Internal.RecipeKJS>): Internal.RecipeFilter;
        printAllTypes(): void;
        static runInParallel<T>(callable: Internal.Callable_<T>): T;
        addRecipe(r: Internal.RecipeJS_, json: boolean): Internal.RecipeJS;
        printExamples(type: string): void;
        stage(filter: Internal.RecipeFilter_, stage: string): void;
        getRecipes(): Special.DocumentedRecipes;
        replaceOutput(filter: Internal.RecipeFilter_, match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): void;
        takeId(recipe: Internal.RecipeJS_, prefix: string, ids: string): ResourceLocation;
        printTypes(): void;
        remove(filter: Internal.RecipeFilter_): void;
        forEachRecipe(filter: Internal.RecipeFilter_, consumer: Internal.Consumer_<Internal.RecipeJS>): void;
        findRecipeIds(filter: Internal.RecipeFilter_): Internal.Collection<ResourceLocation>;
        getRecipes(): Special.DocumentedRecipes;
        countRecipes(filter: Internal.RecipeFilter_): number;
        getRecipeFunction(id: string): Internal.RecipeTypeFunction;
        recipeStream(filter: Internal.RecipeFilter_): Internal.Stream<Internal.RecipeJS>;
        containsRecipe(filter: Internal.RecipeFilter_): boolean;
        replaceInput(filter: Internal.RecipeFilter_, match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): void;
        setItemErrors(b: boolean): void;
        custom(o: {type: Special.RecipeSerializer}): Internal.RecipeJS;
        static runInParallel(runnable: Internal.Runnable_): void;
        get recipes(): Special.DocumentedRecipes
        get recipes(): Special.DocumentedRecipes
        set itemErrors(b: boolean)
        readonly smithing: Internal.RecipeTypeFunction;
        readonly addedRecipes: Internal.Collection<Internal.RecipeJS>;
        readonly shapeless: Internal.RecipeTypeFunction;
        readonly smithingTrim: Internal.RecipeTypeFunction;
        readonly smelting: Internal.RecipeTypeFunction;
        readonly blasting: Internal.RecipeTypeFunction;
        readonly stonecutting: Internal.RecipeTypeFunction;
        readonly smoking: Internal.RecipeTypeFunction;
        readonly campfireCooking: Internal.RecipeTypeFunction;
        static readonly SKIP_ERROR: Internal.Pattern;
        readonly failedCount: Internal.AtomicInteger;
        readonly takenIds: Internal.Map<ResourceLocation, Internal.RecipeJS>;
        readonly originalRecipes: Internal.Map<ResourceLocation, Internal.RecipeJS>;
        readonly shaped: Internal.RecipeTypeFunction;
    }
    type RecipesEventJS_ = RecipesEventJS;
    class PatternIota$1 extends Internal.IotaType<Internal.PatternIota> {
        deserialize(tag: Internal.Tag_, world: Internal.ServerLevel_): Internal.PatternIota;
    }
    type PatternIota$1_ = PatternIota$1;
    class DynamicCommandExceptionType implements Internal.CommandExceptionType {
        constructor(arg0: Internal.Function_<any, Internal.Message>)
        createWithContext(arg0: Internal.ImmutableStringReader_, arg1: any): Internal.CommandSyntaxException;
        create(arg0: any): Internal.CommandSyntaxException;
    }
    type DynamicCommandExceptionType_ = DynamicCommandExceptionType;
    interface BlockStateKJS {
        setRequiresTool(v: boolean): void;
        setDestroySpeed(v: number): void;
        setLightEmission(v: number): void;
        set requiresTool(v: boolean)
        set destroySpeed(v: number)
        set lightEmission(v: number)
    }
    type BlockStateKJS_ = BlockStateKJS;
    class FloatingPoint implements Internal.Cloneable {
        constructor()
        constructor(arg0: me.shedaniel.math.Point_)
        constructor(arg0: Internal.FloatingPoint_)
        constructor(arg0: number, arg1: number)
        getX(): number;
        getLocation(): me.shedaniel.math.Point;
        getY(): number;
        clone(): this;
        setLocation(arg0: number, arg1: number): void;
        translate(arg0: number, arg1: number): void;
        getFloatingLocation(): this;
        move(arg0: number, arg1: number): void;
        get x(): number
        get location(): me.shedaniel.math.Point
        get y(): number
        get floatingLocation(): Internal.FloatingPoint
        x: number;
        y: number;
    }
    type FloatingPoint_ = FloatingPoint;
    class Heightmap$Types extends Internal.Enum<Internal.Heightmap$Types> implements Internal.StringRepresentable {
        static values(): Internal.Heightmap$Types[];
        isOpaque(): Internal.Predicate<Internal.BlockState>;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        keepAfterWorldgen(): boolean;
        getSerializedName(): string;
        getSerializationKey(): string;
        static valueOf($$0: string): Internal.Heightmap$Types;
        sendToClient(): boolean;
        get serializedName(): string
        get serializationKey(): string
        static readonly OCEAN_FLOOR: Internal.Heightmap$Types;
        static readonly MOTION_BLOCKING_NO_LEAVES: Internal.Heightmap$Types;
        static readonly CODEC: Internal.Codec<Internal.Heightmap$Types>;
        static readonly MOTION_BLOCKING: Internal.Heightmap$Types;
        static readonly WORLD_SURFACE: Internal.Heightmap$Types;
        static readonly WORLD_SURFACE_WG: Internal.Heightmap$Types;
        static readonly OCEAN_FLOOR_WG: Internal.Heightmap$Types;
    }
    type Heightmap$Types_ = "motion_blocking_no_leaves" | "ocean_floor" | "motion_blocking" | "world_surface" | Heightmap$Types | "world_surface_wg" | "ocean_floor_wg";
    class NetworkToolMenuHost extends Internal.ItemMenuHost implements Internal.InternalInventoryHost {
        constructor(player: Internal.Player_, slot: number, is: Internal.ItemStack_, host: Internal.IInWorldGridNodeHost_)
        saveChanges(): void;
        isUpgradedWith(upgradeCard: Internal.ItemLike_): boolean;
        getInstalledUpgrades(upgradeCard: Internal.ItemLike_): number;
        getInventory(): Internal.InternalInventory;
        getGridHost(): Internal.IInWorldGridNodeHost;
        onChangeInventory(inv: Internal.InternalInventory_, slot: number): void;
        getInternalInventory(): Internal.InternalInventory;
        get inventory(): Internal.InternalInventory
        get gridHost(): Internal.IInWorldGridNodeHost
        get internalInventory(): Internal.InternalInventory
    }
    type NetworkToolMenuHost_ = NetworkToolMenuHost;
    class GaugeShaper extends Internal.VoxelShaper {
        constructor()
        get(direction: Internal.Direction_, axisAlong: boolean): Internal.VoxelShape;
    }
    type GaugeShaper_ = GaugeShaper;
    interface ServerFunctionManager$TraceCallbacks {
        abstract onCommand(arg0: number, arg1: string): void;
        abstract onReturn(arg0: number, arg1: string, arg2: number): void;
        abstract onCall(arg0: number, arg1: ResourceLocation_, arg2: number): void;
        abstract onError(arg0: number, arg1: string): void;
    }
    type ServerFunctionManager$TraceCallbacks_ = ServerFunctionManager$TraceCallbacks;
    interface DensityFunctions$PureTransformer extends Internal.DensityFunction {
        halfNegative(): Internal.DensityFunction;
        abs(): Internal.DensityFunction;
        abstract maxValue(): number;
        abstract codec(): Internal.KeyDispatchDataCodec<Internal.DensityFunction>;
        compute($$0: Internal.DensityFunction$FunctionContext_): number;
        squeeze(): Internal.DensityFunction;
        abstract transform(arg0: number): number;
        square(): Internal.DensityFunction;
        abstract mapAll(arg0: Internal.DensityFunction$Visitor_): Internal.DensityFunction;
        clamp($$0: number, $$1: number): Internal.DensityFunction;
        quarterNegative(): Internal.DensityFunction;
        cube(): Internal.DensityFunction;
        fillArray($$0: number[], $$1: Internal.DensityFunction$ContextProvider_): void;
        abstract input(): Internal.DensityFunction;
        abstract minValue(): number;
    }
    type DensityFunctions$PureTransformer_ = DensityFunctions$PureTransformer;
    interface VisualEmbedding extends Internal.VisualizationContext {
        abstract createEmbedding(arg0: Vec3i_): this;
        abstract instancerProvider(): Internal.InstancerProvider;
        abstract renderOrigin(): Vec3i;
        abstract transforms(arg0: Internal.Matrix4fc_, arg1: Internal.Matrix3fc_): void;
        abstract "delete"(): void;
    }
    type VisualEmbedding_ = VisualEmbedding;
    class Direction$Plane extends Internal.Enum<Internal.Direction$Plane> implements Internal.Predicate<Internal.Direction>, Internal.Iterable<Internal.Direction> {
        stream(): Internal.Stream<Internal.Direction>;
        static not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
        or(arg0: Internal.Predicate_<Internal.Direction>): Internal.Predicate<Internal.Direction>;
        spliterator(): Internal.Spliterator<Internal.Direction>;
        and(arg0: Internal.Predicate_<Internal.Direction>): Internal.Predicate<Internal.Direction>;
        getRandomAxis($$0: Internal.RandomSource_): Internal.Direction$Axis;
        static values(): Internal.Direction$Plane[];
        iterator(): Internal.Iterator<Internal.Direction>;
        static isEqual<T>(arg0: any): Internal.Predicate<T>;
        test(arg0: any): boolean;
        forEach(arg0: Internal.Consumer_<Internal.Direction>): void;
        getRandomDirection($$0: Internal.RandomSource_): Internal.Direction;
        test($$0: Internal.Direction_): boolean;
        static valueOf($$0: string): Internal.Direction$Plane;
        shuffledCopy($$0: Internal.RandomSource_): Internal.List<Internal.Direction>;
        negate(): Internal.Predicate<Internal.Direction>;
        static readonly HORIZONTAL: Internal.Direction$Plane;
        static readonly VERTICAL: Internal.Direction$Plane;
    }
    type Direction$Plane_ = Direction$Plane | "vertical" | "horizontal";
}
declare namespace net.minecraft.world.entity {
    class EntitySelector {
        static withinDistance($$0: number, $$1: number, $$2: number, $$3: number): Internal.Predicate<Internal.Entity>;
        static pushableBy($$0: Internal.Entity_): Internal.Predicate<Internal.Entity>;
        static notRiding($$0: Internal.Entity_): Internal.Predicate<Internal.Entity>;
        static readonly NO_CREATIVE_OR_SPECTATOR: Internal.Predicate<Internal.Entity>;
        static readonly LIVING_ENTITY_STILL_ALIVE: Internal.Predicate<Internal.Entity>;
        static readonly CAN_BE_COLLIDED_WITH: Internal.Predicate<Internal.Entity>;
        static readonly ENTITY_NOT_BEING_RIDDEN: Internal.Predicate<Internal.Entity>;
        static readonly CONTAINER_ENTITY_SELECTOR: Internal.Predicate<Internal.Entity>;
        static readonly ENTITY_STILL_ALIVE: Internal.Predicate<Internal.Entity>;
        static readonly NO_SPECTATORS: Internal.Predicate<Internal.Entity>;
    }
    type EntitySelector_ = EntitySelector | string;
}
